/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.archive;

import java.net.URL;
import org.fabric3.api.host.stream.UrlSource;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.JavaArtifactIntrospector;
import org.fabric3.spi.contribution.JavaSymbol;
import org.fabric3.spi.contribution.ProviderSymbol;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.contribution.ResourceElement;
import org.fabric3.spi.introspection.IntrospectionContext;

public class ComponentJavaArtifactIntrospector
implements JavaArtifactIntrospector {
    @Override
    public Resource inspect(Class<?> clazz, URL url, Contribution contribution, IntrospectionContext context) {
        String name = clazz.getName();
        if (this.isProvider(name)) {
            UrlSource source = new UrlSource(url);
            Resource resource = new Resource(contribution, source, "text/vnd.fabric3.dsl");
            ProviderSymbol symbol = new ProviderSymbol(name);
            ResourceElement element = new ResourceElement(symbol);
            resource.addResourceElement(element);
            return resource;
        }
        if (!contribution.getManifest().isExtension() && this.isComponent(clazz)) {
            return this.createResource(name, clazz, url, contribution);
        }
        return null;
    }

    private Resource createResource(String name, Class<?> clazz, URL url, Contribution contribution) {
        UrlSource source = new UrlSource(url);
        Resource resource = new Resource(contribution, source, "text/vnd.fabric3.component+java");
        JavaSymbol symbol = new JavaSymbol(name);
        ResourceElement resourceElement = new ResourceElement(symbol, clazz);
        resource.addResourceElement(resourceElement);
        return resource;
    }

    private boolean isProvider(String name) {
        return name.startsWith("f3.") && name.endsWith("Provider");
    }
}

