/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.archive;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.util.FileHelper;
import org.fabric3.spi.contribution.ClasspathProcessor;
import org.fabric3.spi.contribution.ClasspathProcessorRegistry;
import org.fabric3.spi.contribution.Contribution;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class SyntheticDirectoryClasspathProcessor
implements ClasspathProcessor {
    private static final String CONTENT_TYPE = "application/vnd.fabric3.synthetic";
    private final ClasspathProcessorRegistry registry;

    public SyntheticDirectoryClasspathProcessor(@Reference ClasspathProcessorRegistry registry) {
        this.registry = registry;
    }

    @Init
    public void init() {
        this.registry.register(this);
    }

    @Destroy
    public void destroy() {
        this.registry.unregister(this);
    }

    @Override
    public boolean canProcess(Contribution contribution) {
        URL url = contribution.getLocation();
        if (!"file".equals(url.getProtocol())) {
            return false;
        }
        if (!CONTENT_TYPE.equals(contribution.getContentType())) {
            return false;
        }
        File root = FileHelper.toFile(url);
        return root.isDirectory();
    }

    @Override
    public List<URL> process(Contribution contribution) throws Fabric3Exception {
        URL url = contribution.getLocation();
        try {
            ArrayList<URL> classpath = new ArrayList<URL>();
            File root = FileHelper.toFile(url);
            for (File file : root.listFiles()) {
                if (!file.getName().endsWith(".jar")) continue;
                classpath.add(file.toURI().toURL());
            }
            return classpath;
        }
        catch (IOException e) {
            throw new Fabric3Exception(e);
        }
    }
}

