/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.manifest;

import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.host.Version;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.contribution.manifest.MissingPackage;
import org.fabric3.spi.contribution.manifest.JavaExport;
import org.fabric3.spi.contribution.manifest.PackageInfo;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.AbstractValidatingTypeLoader;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.oasisopen.sca.annotation.EagerInit;

@EagerInit
public class JavaExportLoader
extends AbstractValidatingTypeLoader<JavaExport> {
    public JavaExportLoader() {
        this.addAttributes("package", "required", "version", "min", "location", "minInclusive", "max", "maxInclusive");
    }

    @Override
    public JavaExport load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        PackageInfo info;
        Location startLocation = reader.getLocation();
        this.validateAttributes(reader, context, new ModelObject[0]);
        String statement = reader.getAttributeValue(null, "package");
        if (statement == null) {
            MissingPackage failure = new MissingPackage("No package name specified", startLocation);
            context.addError(failure);
            return null;
        }
        String version = reader.getAttributeValue(null, "version");
        if (version != null) {
            Version packageVersion;
            try {
                packageVersion = new Version(version);
            }
            catch (IllegalArgumentException e) {
                context.addError(new InvalidValue("Invalid export version", startLocation, e, new ModelObject[0]));
                packageVersion = new Version("0");
            }
            info = new PackageInfo(statement, packageVersion, true, true);
        } else {
            info = new PackageInfo(statement);
        }
        return new JavaExport(info);
    }
}

