/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.manifest;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.host.Version;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.contribution.manifest.MissingPackage;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.AbstractValidatingTypeLoader;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.UnrecognizedAttribute;
import org.fabric3.spi.model.os.Library;
import org.fabric3.spi.model.os.OperatingSystemSpec;
import org.oasisopen.sca.annotation.EagerInit;

@EagerInit
public class LibraryLoader
extends AbstractValidatingTypeLoader<Library> {
    private static final String OS = "os";
    private static final String LIBRARY = "library";

    public LibraryLoader() {
        this.addAttributes("name", "processor", "version", "min", "max", "minInclusive", "maxInclusive");
    }

    @Override
    public Library load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        Location startLocation = reader.getLocation();
        this.validateLibraryAttributes(reader, context);
        String path = reader.getAttributeValue(null, "path");
        if (path == null) {
            MissingPackage failure = new MissingPackage("No path specified for library declaration", startLocation);
            context.addError(failure);
            return null;
        }
        List<OperatingSystemSpec> systems = this.parseOperatingSystems(reader, context);
        return new Library(path, systems);
    }

    private List<OperatingSystemSpec> parseOperatingSystems(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        ArrayList<OperatingSystemSpec> systems = new ArrayList<OperatingSystemSpec>();
        block4: while (true) {
            switch (reader.next()) {
                case 1: {
                    OperatingSystemSpec system;
                    if (!OS.equals(reader.getName().getLocalPart()) || (system = this.parseOperatingSystem(reader, context)) == null) continue block4;
                    systems.add(system);
                    break;
                }
                case 2: {
                    if (!LIBRARY.equals(reader.getName().getLocalPart())) break;
                    return systems;
                }
            }
        }
    }

    private OperatingSystemSpec parseOperatingSystem(XMLStreamReader reader, IntrospectionContext context) {
        OperatingSystemSpec system;
        Location location = reader.getLocation();
        this.validateAttributes(reader, context, new ModelObject[0]);
        String name = reader.getAttributeValue(null, "name");
        if (name == null) {
            MissingPackage failure = new MissingPackage("No name specified for operating systems declaration", location);
            context.addError(failure);
            return null;
        }
        String versionStr = reader.getAttributeValue(null, "version");
        String minVersion = reader.getAttributeValue(null, "min");
        if (versionStr != null) {
            system = this.parseVersion(name, versionStr, reader, context);
        } else if (minVersion != null) {
            system = this.parseRange(name, minVersion, reader, context);
        } else {
            String processor = reader.getAttributeValue(null, "processor");
            system = new OperatingSystemSpec(name, processor);
        }
        return system;
    }

    private OperatingSystemSpec parseVersion(String name, String versionStr, XMLStreamReader reader, IntrospectionContext context) {
        Location location = reader.getLocation();
        try {
            Version version = new Version(versionStr);
            String minInclusiveAttr = reader.getAttributeValue(null, "minInclusive");
            boolean minInclusive = minInclusiveAttr == null || Boolean.parseBoolean(minInclusiveAttr);
            String processor = reader.getAttributeValue(null, "processor");
            return new OperatingSystemSpec(name, processor, version, minInclusive);
        }
        catch (IllegalArgumentException e) {
            InvalidValue failure = new InvalidValue("Invalid operating systems version", location, e, new ModelObject[0]);
            context.addError(failure);
            return null;
        }
    }

    private OperatingSystemSpec parseRange(String name, String minVersion, XMLStreamReader reader, IntrospectionContext context) {
        Version minimum;
        String processor = reader.getAttributeValue(null, "processor");
        String minInclusiveAttr = reader.getAttributeValue(null, "minInclusive");
        boolean minInclusive = minInclusiveAttr == null || Boolean.parseBoolean(minInclusiveAttr);
        String maxInclusiveAttr = reader.getAttributeValue(null, "maxInclusive");
        boolean maxInclusive = maxInclusiveAttr == null || Boolean.parseBoolean(maxInclusiveAttr);
        String maxVersion = reader.getAttributeValue(null, "max");
        Version maximum = null;
        try {
            minimum = new Version(minVersion);
        }
        catch (IllegalArgumentException e) {
            Location location = reader.getLocation();
            InvalidValue failure = new InvalidValue("Invalid minimum package version", location, e, new ModelObject[0]);
            context.addError(failure);
            return null;
        }
        if (maxVersion != null) {
            try {
                maximum = new Version(maxVersion);
            }
            catch (IllegalArgumentException e) {
                Location location = reader.getLocation();
                InvalidValue failure = new InvalidValue("Invalid maximum package version", location, e, new ModelObject[0]);
                context.addError(failure);
                return null;
            }
        }
        return new OperatingSystemSpec(name, processor, minimum, minInclusive, maximum, maxInclusive);
    }

    private void validateLibraryAttributes(XMLStreamReader reader, IntrospectionContext context) {
        Location location = reader.getLocation();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            if ("path".equals(name)) continue;
            UnrecognizedAttribute failure = new UnrecognizedAttribute(name, location, new ModelObject[0]);
            context.addError(failure);
        }
    }
}

