/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.processor;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.stream.Source;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.component.Composite;
import org.fabric3.contribution.processor.DuplicateComposite;
import org.fabric3.contribution.processor.InvalidXmlArtifact;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ProcessorRegistry;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.contribution.ResourceElement;
import org.fabric3.spi.contribution.ResourceProcessor;
import org.fabric3.spi.contribution.ResourceState;
import org.fabric3.spi.contribution.Symbol;
import org.fabric3.spi.contribution.manifest.QNameSymbol;
import org.fabric3.spi.introspection.DefaultIntrospectionContext;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.Loader;
import org.fabric3.spi.introspection.xml.LoaderException;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class CompositeResourceProcessor
implements ResourceProcessor {
    private Loader loader;
    private final XMLInputFactory xmlFactory;

    public CompositeResourceProcessor(@Reference ProcessorRegistry processorRegistry, @Reference Loader loader) {
        processorRegistry.register(this);
        this.loader = loader;
        this.xmlFactory = XMLInputFactory.newFactory();
    }

    @Override
    public String getContentType() {
        return "text/vnd.fabric3.composite+xml";
    }

    @Override
    public void index(Resource resource, IntrospectionContext context) {
        XMLStreamReader reader = null;
        InputStream stream = null;
        try {
            Source source = resource.getSource();
            stream = source.openStream();
            reader = this.xmlFactory.createXMLStreamReader(stream);
            reader.nextTag();
            Location startLocation = reader.getLocation();
            if (!"composite".equals(reader.getName().getLocalPart())) {
                return;
            }
            String name = reader.getAttributeValue(null, "name");
            if (name == null) {
                context.addError(new MissingAttribute("Composite name not specified", startLocation, new ModelObject[0]));
                return;
            }
            String targetNamespace = reader.getAttributeValue(null, "targetNamespace");
            QName compositeName = new QName(targetNamespace, name);
            QNameSymbol symbol = new QNameSymbol(compositeName);
            ResourceElement<QNameSymbol, Composite> element = new ResourceElement<QNameSymbol, Composite>(symbol);
            resource.addResourceElement(element);
            this.validateUnique(resource, element, reader, context);
        }
        catch (XMLStreamException e) {
            throw new Fabric3Exception(e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void process(Resource resource, IntrospectionContext context) {
        Composite composite;
        Source source = resource.getSource();
        ClassLoader classLoader = context.getClassLoader();
        URI contributionUri = context.getContributionUri();
        URL location = source.getBaseLocation();
        DefaultIntrospectionContext childContext = new DefaultIntrospectionContext(contributionUri, classLoader, location);
        try {
            composite = this.loader.load(source, Composite.class, (IntrospectionContext)childContext);
        }
        catch (LoaderException e) {
            throw new Fabric3Exception(e);
        }
        if (composite == null) {
            InvalidXmlArtifact error = new InvalidXmlArtifact("Invalid composite: " + location, null);
            context.addError(error);
            return;
        }
        boolean found = false;
        for (ResourceElement<?, ?> element : resource.getResourceElements()) {
            if (!((Symbol)element.getSymbol()).getKey().equals(composite.getName())) continue;
            element.setValue(composite);
            found = true;
            break;
        }
        if (!found) {
            String identifier = composite.getName().toString();
            throw new AssertionError((Object)("Resource element not found: " + identifier));
        }
        if (childContext.hasErrors()) {
            context.addErrors(childContext.getErrors());
        }
        if (childContext.hasWarnings()) {
            context.addWarnings(childContext.getWarnings());
        }
        resource.setState(ResourceState.PROCESSED);
    }

    private void validateUnique(Resource resource, ResourceElement<QNameSymbol, Composite> element, XMLStreamReader reader, IntrospectionContext context) {
        Contribution contribution = resource.getContribution();
        block0: for (Resource entry : contribution.getResources()) {
            if (resource == entry || !resource.getContentType().equals(entry.getContentType())) continue;
            for (ResourceElement<?, ?> elementEntry : entry.getResourceElements()) {
                if (!element.getSymbol().equals(elementEntry.getSymbol())) continue;
                QName name = (QName)element.getSymbol().getKey();
                Location location = reader.getLocation();
                Composite composite = element.getValue();
                DuplicateComposite error = new DuplicateComposite("Duplicate composite found with name: " + name, location, composite);
                context.addError(error);
                continue block0;
            }
        }
    }
}

