/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.processor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.fabric3.api.annotation.model.ConfigurationContext;
import org.fabric3.api.annotation.model.Provides;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.model.type.component.Channel;
import org.fabric3.api.model.type.component.Component;
import org.fabric3.api.model.type.component.Composite;
import org.fabric3.api.model.type.component.Implementation;
import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.contribution.processor.DuplicateProviderComposite;
import org.fabric3.contribution.processor.InvalidProviderMethod;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ProcessorRegistry;
import org.fabric3.spi.contribution.ProviderSymbol;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.contribution.ResourceElement;
import org.fabric3.spi.contribution.ResourceProcessor;
import org.fabric3.spi.contribution.ResourceState;
import org.fabric3.spi.contribution.manifest.QNameSymbol;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.dsl.ChannelIntrospector;
import org.fabric3.spi.introspection.java.ImplementationIntrospector;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class ProviderResourceProcessor
implements ResourceProcessor {
    private HostInfo info;
    private Map<String, ImplementationIntrospector> introspectors = Collections.emptyMap();
    private List<ChannelIntrospector> channelIntrospectors = Collections.emptyList();

    public ProviderResourceProcessor(@Reference ProcessorRegistry processorRegistry, @Reference HostInfo info) {
        this.info = info;
        processorRegistry.register(this);
    }

    @Reference(required=false)
    public void setIntrospectors(Map<String, ImplementationIntrospector> processors) {
        this.introspectors = processors;
    }

    @Reference(required=false)
    public void setChannelIntrospectors(List<ChannelIntrospector> channelIntrospectors) {
        this.channelIntrospectors = channelIntrospectors;
    }

    @Override
    public String getContentType() {
        return "text/vnd.fabric3.dsl";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void index(Resource resource, IntrospectionContext context) {
        Class<?> provider;
        ResourceElement<?, ?> element = resource.getResourceElements().get(0);
        ProviderSymbol symbol = (ProviderSymbol)element.getSymbol();
        String className = (String)symbol.getKey();
        try {
            provider = context.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            InvalidProviderMethod error = new InvalidProviderMethod("Error loading provider class: " + className, e);
            context.addError(error);
            return;
        }
        Method[] methodArray = provider.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (true) {
            block14: {
                InvalidProviderMethod error;
                if (n2 >= n) {
                    resource.setState(ResourceState.PROCESSED);
                    return;
                }
                Method method = methodArray[n2];
                try {
                    Composite composite;
                    Object arg;
                    block15: {
                        block16: {
                            block17: {
                                if (!method.isAnnotationPresent(Provides.class)) break block14;
                                if (!Composite.class.equals(method.getReturnType())) {
                                    InvalidProviderMethod error2 = new InvalidProviderMethod("Provides must return type " + Composite.class.getName() + ": " + method);
                                    context.addError(error2);
                                    break block14;
                                }
                                arg = null;
                                if (method.getParameterTypes().length <= 0) break block15;
                                if (method.getParameterTypes().length != 1) break block16;
                                if (!method.getParameterTypes()[0].equals(ConfigurationContext.class)) break block17;
                                arg = this.info;
                                break block15;
                            }
                            if (method.getParameterTypes()[0].equals(String.class)) {
                                arg = this.info.getEnvironment();
                                break block15;
                            } else {
                                error = new InvalidProviderMethod("Unknown provider parameter type: " + method);
                                context.addError(error);
                                break block14;
                            }
                        }
                        error = new InvalidProviderMethod("Provides method cannot take more than one parameter: " + method);
                        context.addError(error);
                        break block14;
                    }
                    if (!Modifier.isStatic(method.getModifiers())) {
                        error = new InvalidProviderMethod("Provides method must be static: " + method);
                        context.addError(error);
                        break block14;
                    }
                    Composite composite2 = composite = arg == null ? (Composite)method.invoke(null, new Object[0]) : (Composite)method.invoke(null, arg);
                    if (composite != null) {
                        URI contributionUri = context.getContributionUri();
                        composite.setContributionUri(contributionUri);
                        for (Channel channel : composite.getChannels().values()) {
                            this.channelIntrospectors.forEach(i -> i.introspect(channel));
                        }
                        for (Component component : composite.getComponents().values()) {
                            component.setContributionUri(contributionUri);
                            ImplementationIntrospector introspector = this.introspectors.get(((Implementation)component.getImplementation()).getType());
                            if (introspector == null) continue;
                            introspector.introspect((InjectingComponentType)component.getComponentType(), context);
                        }
                        QName compositeName = composite.getName();
                        QNameSymbol qNameSymbol = new QNameSymbol(compositeName);
                        ResourceElement<QNameSymbol, Composite> compositeElement = new ResourceElement<QNameSymbol, Composite>(qNameSymbol, composite);
                        Contribution contribution = resource.getContribution();
                        Resource compositeResource = new Resource(contribution, resource.getSource(), "text/vnd.fabric3.composite+xml");
                        compositeResource.addResourceElement(compositeElement);
                        this.validateUnique(compositeResource, compositeElement, method, context);
                        compositeResource.setState(ResourceState.PROCESSED);
                        contribution.addResource(compositeResource);
                    }
                }
                catch (InvocationTargetException e) {
                    error = new InvalidProviderMethod("Error invoking provides method: " + method, e.getTargetException());
                    context.addError(error);
                }
                catch (IllegalAccessException e) {
                    error = new InvalidProviderMethod("Error invoking provides method: " + method, e);
                    context.addError(error);
                }
            }
            ++n2;
        }
    }

    @Override
    public void process(Resource resource, IntrospectionContext context) {
    }

    private void validateUnique(Resource resource, ResourceElement<QNameSymbol, Composite> element, Method method, IntrospectionContext context) {
        Contribution contribution = resource.getContribution();
        block0: for (Resource entry : contribution.getResources()) {
            if (resource == entry || !resource.getContentType().equals(entry.getContentType())) continue;
            for (ResourceElement<?, ?> elementEntry : entry.getResourceElements()) {
                if (!element.getSymbol().equals(elementEntry.getSymbol())) continue;
                QName name = (QName)element.getSymbol().getKey();
                DuplicateProviderComposite error = new DuplicateProviderComposite("Duplicate composite found with name: " + name + ":" + method);
                context.addError(error);
                continue block0;
            }
        }
    }
}

