/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.processor;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.stream.UrlSource;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ContributionProcessor;
import org.fabric3.spi.contribution.ProcessorRegistry;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.util.RegexHelper;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class SymLinkContributionProcessor
implements ContributionProcessor {
    public static final String F3_SYMLINK = "f3.symlink";
    private ProcessorRegistry processorRegistry;

    public SymLinkContributionProcessor(@Reference ProcessorRegistry processorRegistry) {
        this.processorRegistry = processorRegistry;
    }

    @Init
    public void init() {
        this.processorRegistry.register(this);
    }

    @Destroy
    public void destroy() {
        this.processorRegistry.unregister(this);
    }

    @Override
    public boolean canProcess(Contribution contribution) {
        String sourceUrl = contribution.getLocation().toString();
        return sourceUrl.endsWith(".contribution") || contribution.getMetaData(Boolean.class, F3_SYMLINK) != null;
    }

    @Override
    public void processManifest(Contribution contribution, IntrospectionContext context) {
        try {
            Contribution syntheticContribution = this.createSyntheticContribution(contribution);
            this.processorRegistry.processManifest(syntheticContribution, context);
            contribution.overrideLocation(syntheticContribution.getLocation());
            contribution.getAdditionalLocations().addAll(syntheticContribution.getAdditionalLocations());
            contribution.setManifest(syntheticContribution.getManifest());
            contribution.addMetaData(F3_SYMLINK, Boolean.TRUE);
            contribution.addMetaData(contribution.getUri(), syntheticContribution);
        }
        catch (IOException e) {
            throw new Fabric3Exception(e);
        }
    }

    @Override
    public void index(Contribution contribution, IntrospectionContext context) {
        Contribution syntheticContribution = contribution.getMetaData(Contribution.class, contribution.getUri());
        this.processorRegistry.indexContribution(syntheticContribution, context);
        for (Resource resource : syntheticContribution.getResources()) {
            resource.setContribution(contribution);
            contribution.addResource(resource);
        }
    }

    @Override
    public void process(Contribution contribution, IntrospectionContext context) {
        Contribution syntheticContribution = contribution.getMetaData(Contribution.class, contribution.getUri());
        this.processorRegistry.processContribution(syntheticContribution, context);
        contribution.removeMetaData(contribution.getUri());
    }

    private Contribution createSyntheticContribution(Contribution contribution) throws IOException, Fabric3Exception {
        try {
            URL location = contribution.getLocation();
            Path symFile = Paths.get(location.toURI());
            List<String> paths = Files.readAllLines(symFile, Charset.defaultCharset());
            if (paths.isEmpty()) {
                throw new Fabric3Exception("Invalid contribution file: " + location);
            }
            String pathname = paths.get(0);
            pathname = RegexHelper.expandExpression(pathname, s -> {
                String var = s.substring(2, s.length() - 1);
                String path = System.getenv().get(var);
                if (path == null) {
                    throw new Fabric3Exception("Contribution location environment variable not set: " + var);
                }
                return path;
            });
            File file = new File(pathname);
            URL dereferencedLocation = file.toURI().toURL();
            URI contributionUri = URI.create(file.getName());
            UrlSource source = new UrlSource(dereferencedLocation);
            long timestamp = System.currentTimeMillis();
            Contribution syntheticContribution = new Contribution(contributionUri, source, dereferencedLocation, timestamp, "text/vnd.fabric3.exploded");
            if (paths.size() > 1) {
                for (int i = 1; i < paths.size(); ++i) {
                    String subPath = paths.get(i);
                    subPath = RegexHelper.expandExpression(subPath, s -> {
                        String var = s.substring(2, s.length() - 1);
                        String path = System.getenv().get(var);
                        if (path == null) {
                            throw new Fabric3Exception("Contribution location environment variable not set: " + var);
                        }
                        return path;
                    });
                    syntheticContribution.addAdditionalLocation(new File(subPath).toURI().toURL());
                }
            }
            return syntheticContribution;
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }
}

