/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.processor;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.xml.XmlProcessor;
import org.fabric3.spi.contribution.xml.XmlProcessorRegistry;
import org.fabric3.spi.introspection.IntrospectionContext;

public class XmlProcessorRegistryImpl
implements XmlProcessorRegistry {
    private Map<QName, XmlProcessor> cache = new HashMap<QName, XmlProcessor>();

    @Override
    public void register(XmlProcessor processor) {
        this.cache.put(processor.getType(), processor);
    }

    @Override
    public void unregister(QName name) {
        this.cache.remove(name);
    }

    @Override
    public void process(Contribution contribution, XMLStreamReader reader, IntrospectionContext context) {
        QName name = reader.getName();
        XmlProcessor processor = this.cache.get(name);
        if (processor == null) {
            String id = name.toString();
            throw new Fabric3Exception("XML processor not found for: " + id);
        }
        processor.processContent(contribution, reader, context);
    }
}

