/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.processor;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.contribution.xml.XmlResourceElementLoader;
import org.fabric3.spi.contribution.xml.XmlResourceElementLoaderRegistry;
import org.fabric3.spi.introspection.IntrospectionContext;

public class XmlResourceElementLoaderRegistryImpl
implements XmlResourceElementLoaderRegistry {
    private Map<QName, XmlResourceElementLoader> cache = new HashMap<QName, XmlResourceElementLoader>();

    @Override
    public void register(XmlResourceElementLoader loader) {
        this.cache.put(loader.getType(), loader);
    }

    @Override
    public void unregister(QName name) {
        this.cache.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(XMLStreamReader reader, Resource resource, IntrospectionContext context) throws Fabric3Exception, XMLStreamException {
        try {
            QName name = reader.getName();
            XmlResourceElementLoader elementLoader = this.cache.get(name);
            if (elementLoader == null) {
                return;
            }
            elementLoader.load(reader, resource, context);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
        }
    }
}

