/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.processor;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.stream.Source;
import org.fabric3.contribution.processor.InvalidXmlArtifact;
import org.fabric3.spi.contribution.ProcessorRegistry;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.contribution.ResourceProcessor;
import org.fabric3.spi.contribution.ResourceState;
import org.fabric3.spi.contribution.xml.XmlIndexerRegistry;
import org.fabric3.spi.contribution.xml.XmlResourceElementLoaderRegistry;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.xml.LocationAwareXMLStreamReader;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class XmlResourceProcessor
implements ResourceProcessor {
    private ProcessorRegistry processorRegistry;
    private XmlResourceElementLoaderRegistry elementLoaderRegistry;
    private XmlIndexerRegistry indexerRegistry;
    private XMLInputFactory xmlFactory;

    public XmlResourceProcessor(@Reference ProcessorRegistry processorRegistry, @Reference XmlIndexerRegistry indexerRegistry, @Reference XmlResourceElementLoaderRegistry elementLoaderRegistry) {
        this.processorRegistry = processorRegistry;
        this.elementLoaderRegistry = elementLoaderRegistry;
        this.indexerRegistry = indexerRegistry;
        this.xmlFactory = XMLInputFactory.newFactory();
    }

    @Init
    public void init() {
        this.processorRegistry.register(this);
    }

    @Destroy
    public void destroy() {
        this.processorRegistry.unregister(this.getContentType());
    }

    @Override
    public String getContentType() {
        return "application/xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void index(Resource resource, IntrospectionContext context) {
        Source source = resource.getSource();
        XMLStreamReader reader = null;
        InputStream stream = null;
        try {
            stream = source.openStream();
            reader = this.xmlFactory.createXMLStreamReader(stream);
            if (this.skipToFirstTag(reader)) {
                return;
            }
            this.indexerRegistry.index(resource, reader, context);
        }
        catch (XMLStreamException e) {
            resource.setState(ResourceState.ERROR);
            Location location = null;
            if (reader != null) {
                location = reader.getLocation();
            }
            InvalidXmlArtifact warning = new InvalidXmlArtifact("Invalid XML in " + source.getSystemId() + ". The error reported was:\n " + e.getMessage(), location);
            context.addWarning(warning);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void process(Resource resource, IntrospectionContext context) {
        InputStream stream = null;
        XMLStreamReader reader = null;
        try {
            stream = resource.getSource().openStream();
            reader = this.xmlFactory.createXMLStreamReader(stream);
            if (reader.getLocation().getSystemId() == null) {
                reader = new LocationAwareXMLStreamReader(reader, resource.getSource().getSystemId());
            }
            if (this.skipToFirstTag(reader)) {
                resource.setState(ResourceState.PROCESSED);
                return;
            }
            this.elementLoaderRegistry.load(reader, resource, context);
            resource.setState(ResourceState.PROCESSED);
        }
        catch (XMLStreamException e) {
            throw new Fabric3Exception(e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean skipToFirstTag(XMLStreamReader reader) throws XMLStreamException {
        while (reader.hasNext() && 1 != reader.getEventType()) {
            reader.next();
        }
        return 8 == reader.getEventType();
    }
}

