/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.wire;

import java.net.URI;
import org.fabric3.contribution.wire.ClassLoaderWireBuilder;
import org.fabric3.contribution.wire.ClassLoaderWireFilter;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.classloader.MultiParentClassLoader;
import org.fabric3.spi.model.physical.ClassLoaderWire;
import org.oasisopen.sca.annotation.Reference;

public class ClassLoaderWireBuilderImpl
implements ClassLoaderWireBuilder {
    private ClassLoaderRegistry registry;

    public ClassLoaderWireBuilderImpl(@Reference ClassLoaderRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void build(MultiParentClassLoader source, ClassLoaderWire classLoaderWire) {
        URI uri = classLoaderWire.getTargetClassLoader();
        ClassLoader target = this.registry.getClassLoader(uri);
        if (target == null) {
            throw new AssertionError((Object)("Target classloader not found: " + uri));
        }
        String packageName = classLoaderWire.getPackageName();
        if (packageName != null) {
            ClassLoaderWireFilter filter = new ClassLoaderWireFilter(target, packageName);
            source.addParent(filter);
        } else {
            source.addParent(target);
        }
    }
}

