/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.builder;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.fabric.container.builder.ChannelConnector;
import org.fabric3.fabric.container.channel.ChannelConnectionImpl;
import org.fabric3.fabric.container.channel.ChannelManager;
import org.fabric3.fabric.container.channel.EventStreamImpl;
import org.fabric3.spi.container.builder.DirectConnectionFactory;
import org.fabric3.spi.container.builder.SourceConnectionAttacher;
import org.fabric3.spi.container.builder.TargetConnectionAttacher;
import org.fabric3.spi.container.channel.Channel;
import org.fabric3.spi.container.channel.ChannelConnection;
import org.fabric3.spi.container.channel.EventStream;
import org.fabric3.spi.container.channel.EventStreamHandler;
import org.fabric3.spi.container.channel.TransformerHandlerFactory;
import org.fabric3.spi.model.physical.ChannelSide;
import org.fabric3.spi.model.physical.PhysicalChannelConnection;
import org.fabric3.spi.model.physical.PhysicalConnectionSource;
import org.fabric3.spi.model.physical.PhysicalConnectionTarget;
import org.oasisopen.sca.annotation.Reference;

public class ChannelConnectorImpl
implements ChannelConnector {
    private Map<Class<?>, DirectConnectionFactory> connectionFactories = new HashMap();
    private Map<Key, Holder> cachedConnections = new HashMap<Key, Holder>();
    @Reference
    protected ChannelManager channelManager;
    @Reference(required=false)
    protected Map<Class<?>, SourceConnectionAttacher<?>> sourceAttachers = new HashMap();
    @Reference(required=false)
    protected Map<Class<?>, TargetConnectionAttacher<?>> targetAttachers = new HashMap();
    @Reference
    protected TransformerHandlerFactory transformerHandlerFactory;

    @Reference(required=false)
    public void setConnectionFactories(List<DirectConnectionFactory> factories) {
        this.connectionFactories.clear();
        factories.forEach(factory -> factory.getTypes().forEach(type -> this.connectionFactories.put((Class<?>)type, (DirectConnectionFactory)factory)));
    }

    @Override
    public ChannelConnection connect(PhysicalChannelConnection physicalConnection) {
        PhysicalConnectionSource source = physicalConnection.getSource();
        PhysicalConnectionTarget target = physicalConnection.getTarget();
        Key key = new Key(source.getSourceId(), target.getTargetId());
        Holder holder = this.cachedConnections.get(key);
        if (holder != null) {
            holder.count.incrementAndGet();
            return holder.connection;
        }
        SourceConnectionAttacher<?> sourceAttacher = this.sourceAttachers.get(source.getClass());
        if (sourceAttacher == null) {
            throw new Fabric3Exception("Attacher not found for type: " + source.getClass().getName());
        }
        TargetConnectionAttacher<?> targetAttacher = this.targetAttachers.get(target.getClass());
        if (targetAttacher == null) {
            throw new Fabric3Exception("Attacher not found for type: " + target.getClass().getName());
        }
        ChannelConnection connection = this.createConnection(physicalConnection);
        sourceAttacher.attach(source, target, connection);
        targetAttacher.attach(source, target, connection);
        this.cachedConnections.put(key, new Holder(connection));
        return connection;
    }

    @Override
    public void disconnect(PhysicalChannelConnection physicalConnection) {
        PhysicalConnectionSource source = physicalConnection.getSource();
        PhysicalConnectionTarget target = physicalConnection.getTarget();
        Key key = new Key(source.getSourceId(), target.getTargetId());
        Holder holder = this.cachedConnections.get(key);
        if (holder == null) {
            return;
        }
        if (holder.count.decrementAndGet() != 0) {
            return;
        }
        this.cachedConnections.remove(key);
        SourceConnectionAttacher<?> sourceAttacher = this.sourceAttachers.get(source.getClass());
        if (sourceAttacher == null) {
            throw new Fabric3Exception("Attacher not found for type: " + source.getClass().getName());
        }
        TargetConnectionAttacher<?> targetAttacher = this.targetAttachers.get(target.getClass());
        if (targetAttacher == null) {
            throw new Fabric3Exception("Attacher not found for type: " + target.getClass().getName());
        }
        sourceAttacher.detach(source, target);
        targetAttacher.detach(source, target);
    }

    private ChannelConnection createConnection(PhysicalChannelConnection physicalConnection) {
        PhysicalConnectionSource source = physicalConnection.getSource();
        PhysicalConnectionTarget target = physicalConnection.getTarget();
        if (source.isDirectConnection() || target.isDirectConnection()) {
            Supplier<Object> supplier;
            int sequence = source.getSequence();
            String topic = physicalConnection.getTopic();
            URI channelUri = physicalConnection.getChannelUri();
            if (physicalConnection.isBound()) {
                Class<?> type = source.isDirectConnection() ? source.getServiceInterface() : target.getServiceInterface();
                DirectConnectionFactory factory = this.connectionFactories.get(type);
                if (factory == null) {
                    throw new Fabric3Exception("Factory type not found: " + type.getName());
                }
                URI attachUri = physicalConnection.getAttachUri();
                supplier = () -> factory.getConnection(channelUri, attachUri, type, physicalConnection.getTopic()).get();
            } else {
                Channel channel = this.channelManager.getChannel(channelUri, ChannelSide.COLLOCATED);
                if (channel == null) {
                    throw new Fabric3Exception("Channel not found: " + channelUri);
                }
                supplier = () -> channel.getDirectConnection(topic);
            }
            return new ChannelConnectionImpl(supplier, topic, sequence);
        }
        ClassLoader loader = physicalConnection.getTarget().getClassLoader();
        Class<?> eventType = physicalConnection.getEventType();
        EventStreamImpl stream = new EventStreamImpl(eventType);
        this.addTypeTransformer(physicalConnection, stream, loader);
        String topic = physicalConnection.getTopic();
        int sequence = source.getSequence();
        return new ChannelConnectionImpl(stream, topic, sequence);
    }

    private void addTypeTransformer(PhysicalChannelConnection connection, EventStream stream, ClassLoader loader) {
        DataType targetType;
        if (this.transformerHandlerFactory == null) {
            return;
        }
        List<DataType> sourceTypes = connection.getSource().getDataTypes();
        List<DataType> targetTypes = connection.getTarget().getDataTypes();
        if (sourceTypes.isEmpty() || targetTypes.isEmpty()) {
            return;
        }
        if (sourceTypes.size() > 1 || targetTypes.size() > 1) {
            throw new Fabric3Exception("Multi-type events are not supported");
        }
        DataType sourceType = sourceTypes.get(0);
        if (sourceType.equals(targetType = targetTypes.get(0))) {
            return;
        }
        List<Class<?>> eventTypes = Collections.singletonList(stream.getEventType());
        EventStreamHandler handler = this.transformerHandlerFactory.createHandler(sourceType, targetType, eventTypes, loader);
        stream.addHandler(handler);
    }

    private class Holder {
        AtomicInteger count = new AtomicInteger(1);
        ChannelConnection connection;

        public Holder(ChannelConnection connection) {
            this.connection = connection;
        }
    }

    private class Key {
        String sourceId;
        String targetId;

        public Key(String sourceId, String targetId) {
            this.sourceId = sourceId;
            this.targetId = targetId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.sourceId.equals(key.sourceId) && this.targetId.equals(key.targetId);
        }

        public int hashCode() {
            int result = this.sourceId.hashCode();
            result = 31 * result + this.targetId.hashCode();
            return result;
        }
    }
}

