/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.builder.channel;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.fabric.container.builder.channel.ChannelBuilderRegistry;
import org.fabric3.fabric.container.channel.ChannelManager;
import org.fabric3.spi.container.builder.ChannelBuilder;
import org.fabric3.spi.container.channel.Channel;
import org.fabric3.spi.model.physical.ChannelSide;
import org.fabric3.spi.model.physical.PhysicalChannel;
import org.oasisopen.sca.annotation.Reference;

public class ChannelBuilderRegistryImpl
implements ChannelBuilderRegistry {
    private ChannelManager channelManager;
    @Reference(required=false)
    protected Map<String, ChannelBuilder> builders = new HashMap<String, ChannelBuilder>();

    public ChannelBuilderRegistryImpl(@Reference ChannelManager channelManager) {
        this.channelManager = channelManager;
    }

    @Override
    public Channel build(PhysicalChannel physicalChannel) {
        ChannelSide channelSide;
        URI uri = physicalChannel.getUri();
        Channel channel = this.channelManager.getAndIncrementChannel(uri, channelSide = physicalChannel.getChannelSide());
        if (channel != null) {
            return channel;
        }
        ChannelBuilder builder = this.getBuilder(physicalChannel);
        channel = builder.build(physicalChannel);
        this.channelManager.register(channel);
        return channel;
    }

    @Override
    public void dispose(PhysicalChannel physicalChannel) {
        ChannelBuilder builder = this.getBuilder(physicalChannel);
        URI uri = physicalChannel.getUri();
        ChannelSide channelSide = physicalChannel.getChannelSide();
        Channel channel = this.channelManager.getAndDecrementChannel(uri, channelSide);
        if (this.channelManager.getCount(uri, channelSide) == 0) {
            this.channelManager.unregister(uri, channelSide);
            builder.dispose(physicalChannel, channel);
        }
    }

    private ChannelBuilder getBuilder(PhysicalChannel definition) {
        ChannelBuilder builder = this.builders.get(definition.getType());
        if (builder == null) {
            throw new Fabric3Exception("Channel builder not found for type " + definition.getType());
        }
        return builder;
    }
}

