/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.builder.channel;

import java.net.URI;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.fabric.container.channel.ChannelManager;
import org.fabric3.fabric.model.physical.ChannelSource;
import org.fabric3.spi.container.builder.SourceConnectionAttacher;
import org.fabric3.spi.container.channel.Channel;
import org.fabric3.spi.container.channel.ChannelConnection;
import org.fabric3.spi.model.physical.ChannelSide;
import org.fabric3.spi.model.physical.PhysicalConnectionTarget;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class ChannelSourceAttacher
implements SourceConnectionAttacher<ChannelSource> {
    private ChannelManager channelManager;

    public ChannelSourceAttacher(@Reference ChannelManager channelManager) {
        this.channelManager = channelManager;
    }

    @Override
    public void attach(ChannelSource source, PhysicalConnectionTarget target, ChannelConnection connection) throws Fabric3Exception {
        connection.setCloseable(() -> {});
        if (target.isDirectConnection()) {
            return;
        }
        URI uri = source.getUri();
        Channel channel = this.getChannel(uri, source.getChannelSide());
        URI targetUri = target.getUri();
        channel.subscribe(targetUri, connection);
    }

    @Override
    public void detach(ChannelSource source, PhysicalConnectionTarget target) throws Fabric3Exception {
        if (target.isDirectConnection()) {
            return;
        }
        URI uri = source.getUri();
        Channel channel = this.getChannel(uri, source.getChannelSide());
        URI targetUri = target.getUri();
        channel.unsubscribe(targetUri, target.getTopic());
    }

    private Channel getChannel(URI uri, ChannelSide channelSide) throws Fabric3Exception {
        Channel channel = this.channelManager.getChannel(uri, channelSide);
        if (channel == null) {
            throw new Fabric3Exception("Channel not found");
        }
        return channel;
    }
}

