/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.channel;

import org.fabric3.spi.container.channel.EventStream;
import org.fabric3.spi.container.channel.EventStreamHandler;
import org.fabric3.spi.container.channel.PassThroughHandler;
import org.fabric3.spi.util.Closeable;

public class EventStreamImpl
implements EventStream {
    private Class<?> eventType;
    private EventStreamHandler headHandler;
    private EventStreamHandler tailHandler;
    private Closeable closeable;

    public EventStreamImpl(Class<?> eventType) {
        this.eventType = eventType;
        PassThroughHandler handler = new PassThroughHandler();
        this.addHandler(handler);
    }

    @Override
    public Class<?> getEventType() {
        return this.eventType;
    }

    @Override
    public EventStreamHandler getHeadHandler() {
        return this.headHandler;
    }

    @Override
    public EventStreamHandler getTailHandler() {
        return this.tailHandler;
    }

    @Override
    public void addHandler(EventStreamHandler handler) {
        if (this.headHandler == null) {
            this.headHandler = handler;
        } else {
            this.tailHandler.setNext(handler);
        }
        this.tailHandler = handler;
    }

    @Override
    public void addHandler(int index, EventStreamHandler handler) {
        EventStreamHandler next;
        int i = 0;
        EventStreamHandler prev = null;
        for (next = this.headHandler; next != null && i < index; next = next.getNext(), ++i) {
            prev = next;
        }
        if (i == index) {
            if (prev != null) {
                prev.setNext(handler);
            } else {
                this.headHandler = handler;
            }
            handler.setNext(next);
            if (next == null) {
                this.tailHandler = handler;
            }
        } else {
            throw new ArrayIndexOutOfBoundsException(index);
        }
    }

    public void close() {
        if (this.closeable != null) {
            this.closeable.close();
        }
    }

    public void setCloseable(Closeable closeable) {
        this.closeable = closeable;
    }
}

