/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.command;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.fabric.container.command.BuildComponentCommand;
import org.fabric3.fabric.container.command.CommandExecutor;
import org.fabric3.fabric.container.command.CommandExecutorRegistry;
import org.fabric3.spi.container.builder.ComponentBuilder;
import org.fabric3.spi.container.builder.ComponentBuilderListener;
import org.fabric3.spi.container.component.Component;
import org.fabric3.spi.container.component.ComponentManager;
import org.fabric3.spi.model.physical.PhysicalComponent;
import org.oasisopen.sca.annotation.Constructor;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class BuildComponentCommandExecutor
implements CommandExecutor<BuildComponentCommand> {
    private ComponentManager componentManager;
    private CommandExecutorRegistry commandExecutorRegistry;
    private Map<Class<?>, ComponentBuilder> builders;
    private List<ComponentBuilderListener> listeners = Collections.emptyList();

    @Constructor
    public BuildComponentCommandExecutor(@Reference ComponentManager componentManager, @Reference CommandExecutorRegistry commandExecutorRegistry) {
        this.componentManager = componentManager;
        this.commandExecutorRegistry = commandExecutorRegistry;
    }

    public BuildComponentCommandExecutor(ComponentManager componentManager) {
        this.componentManager = componentManager;
    }

    @Init
    public void init() {
        this.commandExecutorRegistry.register(BuildComponentCommand.class, this);
    }

    @Reference(required=false)
    public void setBuilders(Map<Class<?>, ComponentBuilder> builders) {
        this.builders = builders;
    }

    @Reference(required=false)
    public void setListeners(List<ComponentBuilderListener> listeners) {
        this.listeners = listeners;
    }

    @Override
    public void execute(BuildComponentCommand command) {
        PhysicalComponent physicalComponent = command.getComponent();
        Component component = this.build(physicalComponent);
        URI contributionUri = physicalComponent.getContributionUri();
        this.componentManager.register(component);
        for (ComponentBuilderListener listener : this.listeners) {
            listener.onBuild(component, physicalComponent);
        }
    }

    private Component build(PhysicalComponent physicalComponent) {
        ComponentBuilder builder = this.builders.get(physicalComponent.getClass());
        if (builder == null) {
            throw new Fabric3Exception("Builder not found for " + physicalComponent.getClass().getName());
        }
        return builder.build(physicalComponent);
    }
}

