/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.command;

import java.net.URI;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.fabric.container.command.CommandExecutor;
import org.fabric3.fabric.container.command.CommandExecutorRegistry;
import org.fabric3.fabric.container.command.ConnectionCommand;
import org.fabric3.spi.container.component.Component;
import org.fabric3.spi.container.component.ComponentManager;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class ConnectionCommandExecutor
implements CommandExecutor<ConnectionCommand> {
    private ComponentManager componentManager;
    private CommandExecutorRegistry commandExecutorRegistry;

    public ConnectionCommandExecutor(@Reference ComponentManager componentManager, @Reference CommandExecutorRegistry commandExecutorRegistry) {
        this.componentManager = componentManager;
        this.commandExecutorRegistry = commandExecutorRegistry;
    }

    @Init
    public void init() {
        this.commandExecutorRegistry.register(ConnectionCommand.class, this);
    }

    @Override
    public void execute(ConnectionCommand command) {
        URI uri = command.getComponentUri();
        Component component = this.componentManager.getComponent(uri);
        if (component == null) {
            throw new Fabric3Exception("Component not found: " + uri);
        }
        component.startUpdate();
        command.getDetachCommands().forEach(this.commandExecutorRegistry::execute);
        command.getAttachCommands().forEach(this.commandExecutorRegistry::execute);
        component.endUpdate();
    }
}

