/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.command;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.fabric.container.command.CommandExecutor;
import org.fabric3.fabric.container.command.CommandExecutorRegistry;
import org.fabric3.fabric.container.command.DisposeComponentCommand;
import org.fabric3.spi.container.builder.ComponentBuilder;
import org.fabric3.spi.container.builder.ComponentBuilderListener;
import org.fabric3.spi.container.component.Component;
import org.fabric3.spi.container.component.ComponentManager;
import org.fabric3.spi.model.physical.PhysicalComponent;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class DisposeComponentCommandExecutor
implements CommandExecutor<DisposeComponentCommand> {
    private CommandExecutorRegistry executorRegistry;
    private ComponentManager componentManager;
    private Map<Class<?>, ComponentBuilder> builders;
    private List<ComponentBuilderListener> listeners = Collections.emptyList();

    public DisposeComponentCommandExecutor(@Reference CommandExecutorRegistry executorRegistry, @Reference ComponentManager componentManager) {
        this.executorRegistry = executorRegistry;
        this.componentManager = componentManager;
    }

    @Reference(required=false)
    public void setBuilders(Map<Class<?>, ComponentBuilder> builders) {
        this.builders = builders;
    }

    @Reference(required=false)
    public void setListeners(List<ComponentBuilderListener> listeners) {
        this.listeners = listeners;
    }

    @Init
    public void init() {
        this.executorRegistry.register(DisposeComponentCommand.class, this);
    }

    @Override
    public void execute(DisposeComponentCommand command) {
        PhysicalComponent physicalComponent = command.getComponent();
        URI uri = physicalComponent.getComponentUri();
        Component component = this.componentManager.unregister(uri);
        ComponentBuilder builder = this.builders.get(physicalComponent.getClass());
        if (builder == null) {
            throw new Fabric3Exception("Builder not found for " + physicalComponent.getClass().getName());
        }
        builder.dispose(physicalComponent, component);
        for (ComponentBuilderListener listener : this.listeners) {
            listener.onDispose(component, physicalComponent);
        }
    }
}

