/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.component;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.spi.container.component.Component;
import org.fabric3.spi.container.component.ComponentManager;

public class ComponentManagerImpl
implements ComponentManager {
    private Map<URI, Component> components = new ConcurrentHashMap<URI, Component>();

    @Override
    public synchronized void register(Component component) throws Fabric3Exception {
        URI uri = component.getUri();
        if (this.components.containsKey(uri)) {
            throw new Fabric3Exception("A component is already registered for: " + uri.toString());
        }
        this.components.put(uri, component);
    }

    @Override
    public synchronized Component unregister(URI uri) throws Fabric3Exception {
        return this.components.remove(uri);
    }

    @Override
    public Component getComponent(URI name) {
        return this.components.get(name);
    }

    @Override
    public List<Component> getComponents() {
        return new ArrayList<Component>(this.components.values());
    }

    @Override
    public List<Component> getComponentsInHierarchy(URI uri) {
        String stringified = uri.toString();
        ArrayList<Component> hierarchy = new ArrayList<Component>();
        for (Component component : this.components.values()) {
            URI componentUri = component.getUri();
            if (!componentUri.toString().startsWith(stringified)) continue;
            hierarchy.add(component);
        }
        return hierarchy;
    }

    @Override
    public List<Component> getDeployedComponents(URI contributionUri) {
        return this.components.values().stream().filter(component -> contributionUri.equals(component.getContributionUri())).collect(Collectors.toList());
    }
}

