/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.component;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.model.type.RuntimeMode;
import org.fabric3.api.model.type.component.Scope;
import org.fabric3.fabric.container.component.ScopeContainerMonitor;
import org.fabric3.fabric.container.component.SingletonScopeContainer;
import org.fabric3.spi.container.component.GroupInitializationException;
import org.fabric3.spi.container.component.ScopeContainer;
import org.fabric3.spi.container.component.ScopedComponent;
import org.fabric3.spi.container.invocation.WorkContextCache;
import org.fabric3.spi.discovery.DiscoveryAgent;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Service;

@EagerInit
@Service(value={ScopeContainer.class})
public class DomainScopeContainer
extends SingletonScopeContainer {
    private HostInfo info;
    private final List<URI> deferredContexts = new ArrayList<URI>();
    boolean activated;
    protected DiscoveryAgent discoveryAgent;

    @Reference(required=false)
    public void setDiscoveryAgents(List<DiscoveryAgent> agents) {
        if (agents.isEmpty()) {
            return;
        }
        this.discoveryAgent = agents.get(0);
        this.discoveryAgent.registerLeadershipListener(this::onLeaderChange);
    }

    public DomainScopeContainer(@Reference HostInfo info, @Monitor ScopeContainerMonitor monitor) {
        super(Scope.DOMAIN, monitor);
        this.info = info;
    }

    @Override
    @Init
    public void start() {
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Destroy
    public synchronized void stop() {
        List<URI> list = this.deferredContexts;
        synchronized (list) {
            this.deferredContexts.clear();
        }
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startContext(URI uri) throws GroupInitializationException {
        if (RuntimeMode.NODE == this.info.getRuntimeMode() && this.discoveryAgent == null) {
            return;
        }
        if (RuntimeMode.NODE == this.info.getRuntimeMode() && !this.discoveryAgent.isLeader()) {
            List<URI> list = this.deferredContexts;
            synchronized (list) {
                this.deferredContexts.add(uri);
            }
            return;
        }
        this.activated = true;
        super.startContext(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopContext(URI uri) {
        List<URI> list = this.deferredContexts;
        synchronized (list) {
            this.deferredContexts.remove(uri);
        }
        super.stopContext(uri);
    }

    @Override
    public Object getInstance(ScopedComponent component) {
        if (this.discoveryAgent != null && !this.activated) {
            throw new Fabric3Exception("Component instance not active: " + component.getUri());
        }
        return super.getInstance(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLeaderChange(boolean value) {
        if (!value) {
            return;
        }
        this.activated = true;
        List<URI> list = this.deferredContexts;
        synchronized (list) {
            WorkContextCache.getAndResetThreadWorkContext();
            for (URI contributionUri : this.deferredContexts) {
                try {
                    super.startContext(contributionUri);
                }
                catch (GroupInitializationException e) {
                    this.monitor.leaderElectionError(e);
                }
            }
            this.deferredContexts.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopAllContexts() {
        List<URI> list = this.deferredContexts;
        synchronized (list) {
            this.deferredContexts.clear();
        }
        super.stopAllContexts();
    }
}

