/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.wire;

import org.fabric3.spi.container.wire.Interceptor;
import org.fabric3.spi.container.wire.InvocationChain;
import org.fabric3.spi.model.physical.PhysicalOperation;

public class InvocationChainImpl
implements InvocationChain {
    protected PhysicalOperation physicalOperation;
    protected Interceptor interceptorChainHead;
    protected Interceptor interceptorChainTail;

    public InvocationChainImpl(PhysicalOperation operation) {
        this.physicalOperation = operation;
    }

    @Override
    public PhysicalOperation getPhysicalOperation() {
        return this.physicalOperation;
    }

    @Override
    public void addInterceptor(Interceptor interceptor) {
        if (this.interceptorChainHead == null) {
            this.interceptorChainHead = interceptor;
        } else {
            this.interceptorChainTail.setNext(interceptor);
        }
        this.interceptorChainTail = interceptor;
    }

    @Override
    public void addInterceptor(int index, Interceptor interceptor) {
        Interceptor next;
        int i = 0;
        Interceptor prev = null;
        for (next = this.interceptorChainHead; next != null && i < index; next = next.getNext(), ++i) {
            prev = next;
        }
        if (i == index) {
            if (prev != null) {
                prev.setNext(interceptor);
            } else {
                this.interceptorChainHead = interceptor;
            }
            interceptor.setNext(next);
            if (next == null) {
                this.interceptorChainTail = interceptor;
            }
        } else {
            throw new ArrayIndexOutOfBoundsException(index);
        }
    }

    @Override
    public Interceptor getHeadInterceptor() {
        return this.interceptorChainHead;
    }

    @Override
    public Interceptor getTailInterceptor() {
        return this.interceptorChainTail;
    }
}

