/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.wire;

import java.util.Collections;
import java.util.List;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.fabric.container.wire.TransformerInterceptor;
import org.fabric3.spi.container.wire.Interceptor;
import org.fabric3.spi.container.wire.TransformerInterceptorFactory;
import org.fabric3.spi.model.physical.PhysicalOperation;
import org.fabric3.spi.transform.Transformer;
import org.fabric3.spi.transform.TransformerRegistry;
import org.oasisopen.sca.annotation.Reference;

public class TransformerInterceptorFactoryImpl
implements TransformerInterceptorFactory {
    private TransformerRegistry registry;

    public TransformerInterceptorFactoryImpl(@Reference TransformerRegistry registry) {
        this.registry = registry;
    }

    @Override
    public Interceptor createInterceptor(PhysicalOperation definition, List<DataType> sources, List<DataType> targets, ClassLoader targetLoader, ClassLoader sourceLoader) throws Fabric3Exception {
        List<Class<?>> targetTypes = definition.getTargetParameterTypes();
        List<Class<?>> sourceTypes = definition.getSourceParameterTypes();
        Transformer<Object, Object> inTransformer = null;
        DataType selectedSource = null;
        DataType selectedTarget = null;
        for (DataType source : sources) {
            for (DataType target : targets) {
                inTransformer = this.registry.getTransformer(source, target, sourceTypes, targetTypes);
                if (inTransformer == null) continue;
                selectedSource = source;
                selectedTarget = target;
                break;
            }
            if (selectedSource == null) continue;
            break;
        }
        if (inTransformer == null) {
            throw new Fabric3Exception("No transformer found for operation: " + definition.getName());
        }
        List<Class<?>> sourceOutTypes = Collections.singletonList(definition.getSourceReturnType());
        List<Class<?>> targetOutTypes = Collections.singletonList(definition.getTargetReturnType());
        Transformer<Object, Object> outTransformer = this.registry.getTransformer(selectedTarget, selectedSource, targetOutTypes, sourceOutTypes);
        if (outTransformer == null) {
            throw new Fabric3Exception("No transformer from type " + selectedTarget + " to type " + selectedSource);
        }
        return new TransformerInterceptor(inTransformer, outTransformer, targetLoader, sourceLoader);
    }
}

