/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.discovery;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.fabric3.spi.discovery.ConfigurationAgent;
import org.fabric3.spi.discovery.ConfigurationRegistry;
import org.oasisopen.sca.annotation.Reference;

public class ConfigurationRegistryImpl
implements ConfigurationRegistry {
    @Reference(required=false)
    private List<ConfigurationAgent> agents = Collections.emptyList();

    @Override
    public String getValue(String key) {
        ConfigurationAgent agent;
        String value = null;
        Iterator<ConfigurationAgent> iterator = this.agents.iterator();
        while (iterator.hasNext() && (value = (agent = iterator.next()).getValue(key)) == null) {
        }
        if (value == null && (value = System.getenv(key)) == null) {
            value = System.getProperty(key);
        }
        return value;
    }

    @Override
    public void registerListener(String key, Consumer<String> listener) {
        this.agents.forEach(a -> a.registerListener(key, listener));
    }

    @Override
    public void unregisterListener(String key, Consumer<String> listener) {
        this.agents.forEach(a -> a.unregisterListener(key, listener));
    }
}

