/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain;

import java.net.URI;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.contribution.Deployable;
import org.fabric3.api.host.domain.AssemblyException;
import org.fabric3.api.host.domain.Domain;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.model.type.RuntimeMode;
import org.fabric3.api.model.type.component.Composite;
import org.fabric3.fabric.domain.ContributionHelper;
import org.fabric3.fabric.domain.Deployer;
import org.fabric3.fabric.domain.LogicalComponentManager;
import org.fabric3.fabric.domain.collector.Collector;
import org.fabric3.fabric.domain.generator.Deployment;
import org.fabric3.fabric.domain.generator.Generator;
import org.fabric3.fabric.domain.instantiator.InstantiationContext;
import org.fabric3.fabric.domain.instantiator.LogicalModelInstantiator;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ContributionState;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.contribution.ResourceElement;
import org.fabric3.spi.contribution.manifest.QNameSymbol;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;

public abstract class AbstractDomain
implements Domain {
    protected Deployer deployer;
    protected Generator generator;
    protected MetaDataStore metadataStore;
    protected LogicalComponentManager logicalComponentManager;
    protected LogicalModelInstantiator logicalModelInstantiator;
    protected Collector collector;
    protected ContributionHelper contributionHelper;
    protected HostInfo info;

    public AbstractDomain(MetaDataStore metadataStore, LogicalComponentManager lcm, Generator generator, LogicalModelInstantiator instantiator, Deployer deployer, Collector collector, ContributionHelper contributionHelper, HostInfo info) {
        this.metadataStore = metadataStore;
        this.generator = generator;
        this.logicalModelInstantiator = instantiator;
        this.logicalComponentManager = lcm;
        this.deployer = deployer;
        this.collector = collector;
        this.contributionHelper = contributionHelper;
        this.info = info;
    }

    @Override
    public synchronized void include(Composite composite) throws Fabric3Exception {
        this.instantiateAndDeploy(composite);
    }

    @Override
    public synchronized void include(List<URI> uris) throws Fabric3Exception {
        this.include(uris, false);
    }

    @Override
    public synchronized void undeploy(URI uri) throws Fabric3Exception {
        Contribution contribution = this.metadataStore.find(uri);
        if (contribution == null) {
            throw new Fabric3Exception("Contribution not found: " + uri);
        }
        List<Deployable> deployables = contribution.getManifest().getDeployables();
        if (deployables.isEmpty()) {
            return;
        }
        LogicalCompositeComponent domain = this.logicalComponentManager.getDomainComposite();
        this.collector.markForCollection(uri, domain);
        Deployment deployment = this.generator.generate(domain);
        this.collector.collect(domain);
        this.deployer.deploy(deployment);
        contribution.undeploy();
    }

    @Override
    public synchronized void undeploy(Composite composite) throws Fabric3Exception {
        LogicalCompositeComponent domain = this.logicalComponentManager.getDomainComposite();
        URI contributionUri = composite.getContributionUri();
        this.collector.markForCollection(contributionUri, domain);
        Deployment deployment = this.generator.generate(domain);
        this.collector.collect(domain);
        this.deployer.deploy(deployment);
        Contribution contribution = this.metadataStore.find(contributionUri);
        contribution.undeploy();
    }

    private synchronized void include(List<URI> uris, boolean recover) throws Fabric3Exception {
        Set<Contribution> contributions = this.contributionHelper.findContributions(uris);
        List<Composite> deployables = this.contributionHelper.getDeployables(contributions);
        this.instantiateAndDeploy(deployables, contributions, recover);
    }

    private void instantiateAndDeploy(List<Composite> deployables, Set<Contribution> contributions, boolean recover) throws Fabric3Exception {
        LogicalCompositeComponent domain = this.logicalComponentManager.getDomainComposite();
        for (Contribution contribution : contributions) {
            if (ContributionState.STORED != contribution.getState()) continue;
            throw new Fabric3Exception("Contribution is not installed: " + contribution.getUri());
        }
        InstantiationContext context = this.logicalModelInstantiator.include(deployables, domain);
        if (context.hasErrors()) {
            throw new AssemblyException(context.getErrors());
        }
        if (!recover || RuntimeMode.VM == this.info.getRuntimeMode()) {
            this.deploy(domain);
        } else {
            this.collector.markAsProvisioned(domain);
        }
        contributions.forEach(Contribution::deploy);
    }

    private void instantiateAndDeploy(Composite composite) throws Fabric3Exception {
        LogicalCompositeComponent domain = this.logicalComponentManager.getDomainComposite();
        QName name = composite.getName();
        QNameSymbol symbol = new QNameSymbol(name);
        ResourceElement<QNameSymbol, Composite> element = this.metadataStore.find(Composite.class, symbol);
        if (element == null) {
            throw new Fabric3Exception("Composite not found in metadata store: " + name);
        }
        Contribution contribution = element.getResource().getContribution();
        if (ContributionState.STORED == contribution.getState()) {
            throw new Fabric3Exception("Contribution is not installed: " + contribution.getUri());
        }
        InstantiationContext context = this.logicalModelInstantiator.include(composite, domain);
        if (context.hasErrors()) {
            throw new AssemblyException(context.getErrors());
        }
        this.deploy(domain);
        contribution.deploy();
    }

    private void deploy(LogicalCompositeComponent domain) throws Fabric3Exception {
        Deployment deployment = this.generator.generate(domain);
        this.collector.markAsProvisioned(domain);
        this.deployer.deploy(deployment);
    }
}

