/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain;

import java.net.URI;
import org.fabric3.api.annotation.Source;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.api.host.Names;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.model.type.component.Component;
import org.fabric3.api.model.type.component.Composite;
import org.fabric3.fabric.domain.LCMMonitor;
import org.fabric3.fabric.domain.LogicalComponentManager;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.model.type.component.CompositeImplementation;
import org.fabric3.spi.util.UriHelper;
import org.oasisopen.sca.annotation.Constructor;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

public class LogicalComponentManagerImpl
implements LogicalComponentManager {
    private URI domainUri;
    private String autowireValue;
    private boolean autowire = true;
    private LogicalCompositeComponent domain;
    private LCMMonitor monitor;

    public LogicalComponentManagerImpl() {
        this.domainUri = Names.RUNTIME_URI;
        this.initializeDomainComposite();
    }

    @Constructor
    public LogicalComponentManagerImpl(@Reference HostInfo info) {
        this.domainUri = info.getDomain();
    }

    @Property(required=false)
    @Source(value="$systemConfig/f3:domain/@autowire")
    public void setAutowire(String value) {
        this.autowireValue = value;
    }

    @Monitor
    public void setMonitor(LCMMonitor monitor) {
        this.monitor = monitor;
    }

    @Init
    public void init() {
        if (this.autowireValue != null) {
            boolean autowire;
            if ("ON".equalsIgnoreCase(this.autowireValue.trim())) {
                autowire = true;
            } else if ("OFF".equalsIgnoreCase(this.autowireValue.trim())) {
                autowire = false;
            } else {
                this.monitor.invalidAutowireValue(this.autowireValue);
                return;
            }
            this.autowire = autowire;
        }
        this.initializeDomainComposite();
    }

    @Override
    public LogicalComponent<?> getComponent(URI uri) {
        String defragmentedUri = UriHelper.getDefragmentedNameAsString(uri);
        String domainString = this.domain.getUri().toString();
        String[] hierarchy = defragmentedUri.substring(domainString.length() + 1).split("/");
        String currentUri = domainString;
        LogicalComponent currentComponent = this.domain;
        for (String name : hierarchy) {
            currentUri = currentUri + "/" + name;
            if (currentComponent instanceof LogicalCompositeComponent) {
                LogicalCompositeComponent composite = currentComponent;
                currentComponent = composite.getComponent(URI.create(currentUri));
            }
            if (currentComponent != null) continue;
            return null;
        }
        return currentComponent;
    }

    @Override
    public LogicalCompositeComponent getDomainComposite() {
        return this.domain;
    }

    private void initializeDomainComposite() {
        Composite type = new Composite(null);
        CompositeImplementation impl = new CompositeImplementation();
        impl.setComponentType(type);
        Component<CompositeImplementation> definition = new Component<CompositeImplementation>(this.domainUri.toString());
        definition.setImplementation(impl);
        definition.setContributionUri(Names.BOOT_CONTRIBUTION);
        this.domain = new LogicalCompositeComponent(this.domainUri, definition, this.autowire);
        this.domain.setState(LogicalState.PROVISIONED);
    }
}

