/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.collector;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.fabric3.api.model.type.component.Resource;
import org.fabric3.fabric.domain.collector.Collector;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalChannel;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalResource;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.model.instance.LogicalWire;

public class CollectorImpl
implements Collector {
    @Override
    public void markAsProvisioned(LogicalCompositeComponent composite) {
        for (LogicalComponent<?> logicalComponent : composite.getComponents()) {
            if (logicalComponent instanceof LogicalCompositeComponent) {
                this.markAsProvisioned((LogicalCompositeComponent)logicalComponent);
            }
            if (LogicalState.NEW == logicalComponent.getState()) {
                logicalComponent.setState(LogicalState.PROVISIONED);
            }
            for (LogicalService service : logicalComponent.getServices()) {
                service.getBindings().stream().filter(binding -> LogicalState.NEW == binding.getState()).forEach(binding -> binding.setState(LogicalState.PROVISIONED));
                service.getCallbackBindings().stream().filter(binding -> LogicalState.NEW == binding.getState()).forEach(binding -> binding.setState(LogicalState.PROVISIONED));
            }
            for (LogicalReference reference : logicalComponent.getReferences()) {
                reference.getBindings().stream().filter(binding -> LogicalState.NEW == binding.getState()).forEach(binding -> binding.setState(LogicalState.PROVISIONED));
                reference.getCallbackBindings().stream().filter(binding -> LogicalState.NEW == binding.getState()).forEach(binding -> binding.setState(LogicalState.PROVISIONED));
            }
        }
        for (List list : composite.getWires().values()) {
            list.stream().filter(wire -> LogicalState.NEW == wire.getState()).forEach(wire -> wire.setState(LogicalState.PROVISIONED));
        }
        for (LogicalChannel logicalChannel : composite.getChannels()) {
            LogicalBinding binding2;
            if (LogicalState.NEW == logicalChannel.getState()) {
                logicalChannel.setState(LogicalState.PROVISIONED);
            }
            if ((binding2 = logicalChannel.getBinding()) == null || LogicalState.NEW != binding2.getState()) continue;
            binding2.setState(LogicalState.PROVISIONED);
        }
        composite.getResources().stream().filter(resource -> LogicalState.NEW == resource.getState()).forEach(resource -> resource.setState(LogicalState.PROVISIONED));
    }

    @Override
    public void markForCollection(URI contributionUri, LogicalCompositeComponent composite) {
        for (LogicalComponent<?> logicalComponent : composite.getComponents()) {
            if (contributionUri.equals(logicalComponent.getDefinition().getContributionUri())) {
                if (logicalComponent.getDefinition() != null && !contributionUri.equals(logicalComponent.getDefinition().getContributionUri())) continue;
                if (logicalComponent instanceof LogicalCompositeComponent) {
                    this.markForCollection(contributionUri, (LogicalCompositeComponent)logicalComponent);
                }
                logicalComponent.setState(LogicalState.MARKED);
                for (LogicalService logicalService : logicalComponent.getServices()) {
                    for (LogicalBinding logicalBinding : logicalService.getBindings()) {
                        logicalBinding.setState(LogicalState.MARKED);
                    }
                }
                for (LogicalReference logicalReference : logicalComponent.getReferences()) {
                    for (LogicalBinding logicalBinding : logicalReference.getBindings()) {
                        logicalBinding.setState(LogicalState.MARKED);
                    }
                    for (LogicalWire logicalWire : composite.getWires(logicalReference)) {
                        logicalWire.setState(LogicalState.MARKED);
                    }
                }
                continue;
            }
            for (LogicalService logicalService : logicalComponent.getServices()) {
                logicalService.getBindings().stream().filter(binding -> contributionUri.equals(binding.getTargetContribution())).forEach(binding -> binding.setState(LogicalState.MARKED));
                logicalService.getCallbackBindings().stream().filter(binding -> contributionUri.equals(binding.getTargetContribution())).forEach(binding -> binding.setState(LogicalState.MARKED));
            }
            for (List list : composite.getWires().values()) {
                for (LogicalWire logicalWire : list) {
                    if (LogicalState.MARKED == logicalWire.getState() || !contributionUri.equals(logicalWire.getTargetContribution())) continue;
                    logicalWire.setState(LogicalState.MARKED);
                }
            }
        }
        for (LogicalChannel logicalChannel : composite.getChannels()) {
            LogicalBinding binding3;
            if (logicalChannel.getDefinition() != null && !contributionUri.equals(logicalChannel.getDefinition().getContributionUri())) continue;
            if (contributionUri.equals(logicalChannel.getDefinition().getContributionUri())) {
                logicalChannel.setState(LogicalState.MARKED);
            }
            if ((binding3 = logicalChannel.getBinding()) == null || !contributionUri.equals(binding3.getTargetContribution())) continue;
            binding3.setState(LogicalState.MARKED);
        }
        for (LogicalResource logicalResource : composite.getResources()) {
            if (!contributionUri.equals(((Resource)logicalResource.getDefinition()).getContributionUri())) continue;
            logicalResource.setState(LogicalState.MARKED);
        }
    }

    @Override
    public void collect(LogicalCompositeComponent composite) {
        Iterator<LogicalComponent<?>> iter = composite.getComponents().iterator();
        while (iter.hasNext()) {
            LogicalComponent<?> component = iter.next();
            if (LogicalState.MARKED == component.getState()) {
                iter.remove();
                continue;
            }
            for (LogicalService logicalService : component.getServices()) {
                this.removeMarkedBindings(logicalService.getBindings().iterator());
                this.removeMarkedBindings(logicalService.getCallbackBindings().iterator());
            }
            for (LogicalReference logicalReference : component.getReferences()) {
                this.removeMarkedBindings(logicalReference.getBindings().iterator());
                this.removeMarkedBindings(logicalReference.getCallbackBindings().iterator());
            }
            if (!(component instanceof LogicalCompositeComponent)) continue;
            this.collect((LogicalCompositeComponent)component);
        }
        ArrayList toRemove = new ArrayList();
        for (Map.Entry entry : composite.getWires().entrySet()) {
            Iterator it = ((List)entry.getValue()).iterator();
            while (it.hasNext()) {
                LogicalWire wire = (LogicalWire)it.next();
                if (LogicalState.MARKED != wire.getState()) continue;
                it.remove();
            }
            if (!((List)entry.getValue()).isEmpty()) continue;
            toRemove.add(entry.getKey());
        }
        for (LogicalReference logicalReference : toRemove) {
            composite.getWires().remove(logicalReference);
        }
        Iterator<LogicalChannel> channelIter = composite.getChannels().iterator();
        while (channelIter.hasNext()) {
            LogicalChannel logicalChannel = channelIter.next();
            if (LogicalState.MARKED != logicalChannel.getState()) continue;
            channelIter.remove();
        }
        Iterator<LogicalResource<?>> iterator = composite.getResources().iterator();
        while (iterator.hasNext()) {
            LogicalResource<?> resource = iterator.next();
            if (LogicalState.MARKED != resource.getState()) continue;
            iterator.remove();
        }
    }

    private void removeMarkedBindings(Iterator<LogicalBinding<?>> iter) {
        while (iter.hasNext()) {
            LogicalBinding<?> binding = iter.next();
            if (LogicalState.MARKED != binding.getState()) continue;
            iter.remove();
        }
    }
}

