/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.generator.channel;

import java.net.URI;
import java.util.Map;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.fabric.domain.generator.channel.ChannelDirection;
import org.fabric3.fabric.domain.generator.channel.ChannelGenerator;
import org.fabric3.spi.domain.generator.ChannelGeneratorExtension;
import org.fabric3.spi.model.instance.LogicalChannel;
import org.fabric3.spi.model.physical.ChannelSide;
import org.fabric3.spi.model.physical.PhysicalChannel;
import org.oasisopen.sca.annotation.Reference;

public class ChannelGeneratorImpl
implements ChannelGenerator {
    @Reference
    protected Map<String, ChannelGeneratorExtension> extensions;

    @Override
    public PhysicalChannel generate(LogicalChannel channel, URI contributionUri, ChannelDirection direction) {
        String type = channel.getDefinition().getType();
        ChannelGeneratorExtension generator = this.extensions.get(type);
        if (generator == null) {
            throw new Fabric3Exception("Channel generator not found: " + type);
        }
        PhysicalChannel physicalChannel = generator.generate(channel, contributionUri);
        if (!channel.getBindings().isEmpty()) {
            physicalChannel.setBound(true);
            physicalChannel.setChannelSide(ChannelDirection.CONSUMER == direction ? ChannelSide.CONSUMER : ChannelSide.PRODUCER);
        } else {
            physicalChannel.setChannelSide(ChannelSide.COLLOCATED);
        }
        return physicalChannel;
    }
}

