/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.generator.component;

import java.net.URI;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.fabric.container.command.Command;
import org.fabric3.fabric.domain.generator.CommandGenerator;
import org.fabric3.fabric.domain.generator.GeneratorRegistry;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.domain.generator.ComponentGenerator;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.physical.PhysicalComponent;

public abstract class AbstractBuildComponentCommandGenerator<T extends Command>
implements CommandGenerator<T> {
    private GeneratorRegistry generatorRegistry;
    private ClassLoaderRegistry classLoaderRegistry;

    public AbstractBuildComponentCommandGenerator(GeneratorRegistry generatorRegistry, ClassLoaderRegistry classLoaderRegistry) {
        this.generatorRegistry = generatorRegistry;
        this.classLoaderRegistry = classLoaderRegistry;
    }

    protected PhysicalComponent generateDefinition(LogicalComponent<?> component) throws Fabric3Exception {
        Object implementation = component.getDefinition().getImplementation();
        Class<?> type = implementation.getClass();
        ComponentGenerator<LogicalComponent<?>> generator = this.generatorRegistry.getComponentGenerator(type);
        if (generator == null) {
            throw new Fabric3Exception("Generator not found: " + type.getName());
        }
        PhysicalComponent physicalComponent = generator.generate(component);
        URI uri = component.getUri();
        physicalComponent.setComponentUri(uri);
        URI contributionUri = component.getDefinition().getContributionUri();
        physicalComponent.setContributionUri(contributionUri);
        physicalComponent.setClassLoader(this.classLoaderRegistry.getClassLoader(contributionUri));
        return physicalComponent;
    }
}

