/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.generator.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.fabric.container.command.Command;
import org.fabric3.fabric.domain.generator.CommandGenerator;
import org.fabric3.fabric.domain.generator.Deployment;
import org.fabric3.fabric.domain.generator.Generator;
import org.fabric3.fabric.domain.generator.context.StartContextCommandGenerator;
import org.fabric3.fabric.domain.generator.context.StopContextCommandGenerator;
import org.fabric3.fabric.domain.generator.resource.DomainResourceCommandGenerator;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalResource;
import org.oasisopen.sca.annotation.Constructor;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class GeneratorImpl
implements Generator {
    private List<CommandGenerator> commandGenerators;
    private StartContextCommandGenerator startContextCommandGenerator;
    private StopContextCommandGenerator stopContextCommandGenerator;
    @Reference
    private DomainResourceCommandGenerator resourceGenerator;

    @Constructor
    public GeneratorImpl(@Reference List<CommandGenerator> commandGenerators, @Reference StartContextCommandGenerator startContextCommandGenerator, @Reference StopContextCommandGenerator stopContextCommandGenerator) {
        this.startContextCommandGenerator = startContextCommandGenerator;
        this.stopContextCommandGenerator = stopContextCommandGenerator;
        this.commandGenerators = this.sortGenerators(commandGenerators);
    }

    @Override
    public Deployment generate(LogicalCompositeComponent domain) throws Fabric3Exception {
        Optional<Command> command;
        List<LogicalComponent<?>> components = domain.getComponents().stream().collect(Collectors.toList());
        Deployment deployment = new Deployment();
        List<Command> stopCommands = this.stopContextCommandGenerator.generate(components);
        deployment.addCommands(stopCommands);
        if (this.resourceGenerator != null) {
            for (LogicalResource logicalResource : domain.getResources()) {
                command = this.resourceGenerator.generateBuild(logicalResource);
                command.ifPresent(deployment::addCommand);
            }
        }
        for (CommandGenerator commandGenerator : this.commandGenerators) {
            for (LogicalComponent logicalComponent : components) {
                Optional<Command> command2 = commandGenerator.generate(logicalComponent);
                command2.ifPresent(generated -> {
                    if (!deployment.getCommands().contains(generated)) {
                        deployment.addCommand((Command)generated);
                    }
                });
            }
        }
        if (this.resourceGenerator != null) {
            for (LogicalResource logicalResource : domain.getResources()) {
                command = this.resourceGenerator.generateDispose(logicalResource);
                command.ifPresent(deployment::addCommand);
            }
        }
        List<Command> startCommands = this.startContextCommandGenerator.generate(components);
        deployment.addCommands(startCommands);
        return deployment;
    }

    private List<CommandGenerator> sortGenerators(List<? extends CommandGenerator> commandGenerators) {
        Comparator generatorComparator = (first, second) -> first.getOrder() - second.getOrder();
        ArrayList<CommandGenerator> sorted = new ArrayList<CommandGenerator>(commandGenerators);
        Collections.sort(sorted, generatorComparator);
        return sorted;
    }
}

