/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.generator.wire;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.component.Binding;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.fabric.container.command.AttachWireCommand;
import org.fabric3.fabric.container.command.ConnectionCommand;
import org.fabric3.fabric.container.command.DetachWireCommand;
import org.fabric3.fabric.domain.generator.CommandGenerator;
import org.fabric3.fabric.domain.generator.wire.WireGenerator;
import org.fabric3.spi.domain.generator.CallbackBindingGenerator;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.model.physical.PhysicalWire;
import org.oasisopen.sca.annotation.Reference;

public class BoundServiceCommandGenerator
implements CommandGenerator<ConnectionCommand> {
    private WireGenerator wireGenerator;
    private Map<Class<?>, CallbackBindingGenerator> generators = Collections.emptyMap();

    public BoundServiceCommandGenerator(@Reference WireGenerator wireGenerator) {
        this.wireGenerator = wireGenerator;
    }

    @Override
    public int getOrder() {
        return 3;
    }

    @Reference(required=false)
    public void setCallbackBindingGenerators(Map<Class<?>, CallbackBindingGenerator> generators) {
        this.generators = generators;
    }

    @Override
    public Optional<ConnectionCommand> generate(LogicalComponent<?> component) {
        if (component instanceof LogicalCompositeComponent) {
            return Optional.empty();
        }
        boolean bindingChange = false;
        block0: for (LogicalService service : component.getServices()) {
            for (LogicalBinding<?> binding : service.getBindings()) {
                if (binding.getState() != LogicalState.NEW && binding.getState() != LogicalState.MARKED) continue;
                bindingChange = true;
                continue block0;
            }
        }
        if (LogicalState.PROVISIONED == component.getState() && !bindingChange) {
            return Optional.empty();
        }
        ConnectionCommand command = new ConnectionCommand(component.getUri());
        this.generatePhysicalWires(component, command);
        if (command.getAttachCommands().isEmpty() && command.getDetachCommands().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(command);
    }

    private void generatePhysicalWires(LogicalComponent<?> component, ConnectionCommand command) {
        for (LogicalService service : component.getServices()) {
            if (service.getBindings().isEmpty()) continue;
            ServiceContract callbackContract = service.getServiceContract().getCallbackContract();
            LogicalBinding callbackBinding = null;
            URI callbackUri = null;
            if (callbackContract != null) {
                List<LogicalBinding<?>> callbackBindings = service.getCallbackBindings();
                if (callbackBindings.isEmpty()) {
                    this.generateCallbackBindings(service);
                }
                if (callbackBindings.size() != 1) {
                    String string = service.getUri().toString();
                    throw new UnsupportedOperationException("The runtime requires exactly one callback binding to be specified on service: " + string);
                }
                callbackBinding = (LogicalBinding)callbackBindings.get(0);
                callbackUri = ((Binding)callbackBinding.getDefinition()).getTargetUri();
            }
            for (LogicalBinding logicalBinding : service.getBindings()) {
                if (logicalBinding.getState() != LogicalState.NEW && logicalBinding.getState() != LogicalState.MARKED) continue;
                PhysicalWire physicalWire = this.wireGenerator.generateService(logicalBinding, callbackUri);
                if (LogicalState.MARKED == logicalBinding.getState()) {
                    DetachWireCommand detachWireCommand = new DetachWireCommand();
                    detachWireCommand.setPhysicalWireDefinition(physicalWire);
                    command.add(detachWireCommand);
                    continue;
                }
                AttachWireCommand attachWireCommand = new AttachWireCommand();
                attachWireCommand.setPhysicalWireDefinition(physicalWire);
                command.add(attachWireCommand);
            }
            if (callbackBinding == null || callbackBinding.getState() != LogicalState.NEW && callbackBinding.getState() != LogicalState.MARKED) continue;
            PhysicalWire physicalWire = this.wireGenerator.generateServiceCallback(callbackBinding);
            if (LogicalState.MARKED == callbackBinding.getState()) {
                DetachWireCommand detachWireCommand = new DetachWireCommand();
                detachWireCommand.setPhysicalWireDefinition(physicalWire);
                command.add(detachWireCommand);
                continue;
            }
            AttachWireCommand attachWireCommand = new AttachWireCommand();
            attachWireCommand.setPhysicalWireDefinition(physicalWire);
            command.add(attachWireCommand);
        }
    }

    private void generateCallbackBindings(LogicalService service) {
        for (LogicalBinding<?> logicalBinding : service.getBindings()) {
            CallbackBindingGenerator generator = this.generators.get(logicalBinding.getDefinition().getClass());
            if (generator == null) {
                throw new Fabric3Exception("Callback generator not found for:" + ((Binding)logicalBinding.getDefinition()).getType());
            }
            Object definition = generator.generateServiceCallback(logicalBinding);
            ((ModelObject)definition).setParent(service.getDefinition());
            LogicalBinding logicalCallback = new LogicalBinding(definition, service);
            service.addCallbackBinding(logicalCallback);
        }
    }
}

