/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.generator.wire;

import java.util.List;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.api.model.type.contract.Operation;
import org.fabric3.spi.contract.OperationResolver;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalInvocable;
import org.fabric3.spi.model.instance.LogicalOperation;

public class OperationResolverImpl
implements OperationResolver {
    @Override
    public LogicalOperation resolve(LogicalOperation source, List<LogicalOperation> targets) {
        Operation sourceDefinition = source.getDefinition();
        for (LogicalOperation target : targets) {
            DataType targetOutputType;
            Operation targetDefinition = target.getDefinition();
            if (!sourceDefinition.getName().equals(targetDefinition.getName())) continue;
            List<DataType> sourceInputTypes = sourceDefinition.getInputTypes();
            DataType sourceOutputType = sourceDefinition.getOutputType();
            if (!sourceOutputType.equals(targetOutputType = targetDefinition.getOutputType()) || !sourceInputTypes.equals(targetDefinition.getInputTypes())) continue;
            return target;
        }
        LogicalInvocable parent = (LogicalInvocable)source.getParent();
        if (parent != null) {
            String sourceComponent = ((LogicalComponent)parent.getParent()).getUri().toString();
            throw new Fabric3Exception("Target operation not found for " + sourceDefinition.getName() + " on source component " + sourceComponent);
        }
        throw new Fabric3Exception("Target operation not found for " + sourceDefinition.getName());
    }
}

