/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.generator.wire;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.api.model.type.contract.Operation;
import org.fabric3.fabric.domain.generator.GeneratorRegistry;
import org.fabric3.fabric.domain.generator.wire.PhysicalOperationGenerator;
import org.fabric3.spi.contract.OperationResolver;
import org.fabric3.spi.domain.generator.InterceptorGenerator;
import org.fabric3.spi.model.instance.LogicalOperation;
import org.fabric3.spi.model.physical.PhysicalInterceptor;
import org.fabric3.spi.model.physical.PhysicalOperation;
import org.oasisopen.sca.annotation.Reference;

public class PhysicalOperationGeneratorImpl
implements PhysicalOperationGenerator {
    private OperationResolver operationResolver;
    private GeneratorRegistry generatorRegistry;

    public PhysicalOperationGeneratorImpl(@Reference OperationResolver operationResolver, @Reference GeneratorRegistry generatorRegistry) {
        this.operationResolver = operationResolver;
        this.generatorRegistry = generatorRegistry;
    }

    @Override
    public Set<PhysicalOperation> generateOperations(List<LogicalOperation> operations) {
        HashSet<PhysicalOperation> physicalOperations = new HashSet<PhysicalOperation>(operations.size());
        for (LogicalOperation operation : operations) {
            PhysicalOperation physicalOperation = this.generate(operation);
            physicalOperations.add(physicalOperation);
        }
        return physicalOperations;
    }

    @Override
    public Set<PhysicalOperation> generateOperations(List<LogicalOperation> sources, List<LogicalOperation> targets, boolean remote) {
        HashSet<PhysicalOperation> physicalOperations = new HashSet<PhysicalOperation>(sources.size());
        for (LogicalOperation source : sources) {
            LogicalOperation target = this.operationResolver.resolve(source, targets);
            PhysicalOperation physicalOperation = this.generate(source, target);
            physicalOperations.add(physicalOperation);
            if (remote) continue;
            Set<PhysicalInterceptor> interceptors = this.generateInterceptors(source, target);
            physicalOperation.setInterceptors(interceptors);
        }
        return physicalOperations;
    }

    private Set<PhysicalInterceptor> generateInterceptors(LogicalOperation source, LogicalOperation target) {
        LinkedHashSet<PhysicalInterceptor> interceptors = new LinkedHashSet<PhysicalInterceptor>();
        for (InterceptorGenerator interceptorGenerator : this.generatorRegistry.getInterceptorGenerators()) {
            Optional<PhysicalInterceptor> optional = interceptorGenerator.generate(source, target);
            optional.ifPresent(interceptors::add);
        }
        return interceptors;
    }

    private PhysicalOperation generate(LogicalOperation source) {
        Operation o = source.getDefinition();
        PhysicalOperation operation = new PhysicalOperation();
        operation.setName(o.getName());
        operation.setOneWay(o.isOneWay());
        operation.setRemotable(o.isRemotable());
        Class<?> returnType = o.getOutputType().getType();
        operation.setSourceReturnType(returnType);
        operation.setTargetReturnType(returnType);
        for (DataType fault : o.getFaultTypes()) {
            Class<?> faultType = fault.getType();
            operation.addSourceFaultType(faultType);
            operation.addTargetFaultType(faultType);
        }
        List<DataType> params = o.getInputTypes();
        for (DataType param : params) {
            Class<?> paramType = param.getType();
            operation.addSourceParameterType(paramType);
            operation.addTargetParameterType(paramType);
        }
        return operation;
    }

    private PhysicalOperation generate(LogicalOperation source, LogicalOperation target) {
        Operation o = source.getDefinition();
        PhysicalOperation operation = new PhysicalOperation();
        operation.setName(o.getName());
        operation.setRemotable(o.isRemotable());
        operation.setOneWay(o.isOneWay());
        Class<?> returnType = o.getOutputType().getType();
        operation.setSourceReturnType(returnType);
        for (DataType dataType : o.getFaultTypes()) {
            Class<?> faultType = dataType.getType();
            operation.addSourceFaultType(faultType);
        }
        List<DataType> params = o.getInputTypes();
        for (DataType param : params) {
            Class<?> paramType = param.getType();
            operation.addSourceParameterType(paramType);
        }
        Operation operation2 = target.getDefinition();
        Class<?> targetReturnType = operation2.getOutputType().getType();
        operation.setTargetReturnType(targetReturnType);
        for (DataType targetFault : operation2.getFaultTypes()) {
            Class<?> faultType = targetFault.getType();
            operation.addTargetFaultType(faultType);
        }
        List<DataType> targetParams = operation2.getInputTypes();
        for (DataType param : targetParams) {
            Class<?> paramType = param.getType();
            operation.addTargetParameterType(paramType);
        }
        return operation;
    }
}

