/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.instantiator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.namespace.QName;
import org.fabric3.api.model.type.component.Component;
import org.fabric3.api.model.type.component.Composite;
import org.fabric3.api.model.type.component.Implementation;
import org.fabric3.api.model.type.component.Include;
import org.fabric3.api.model.type.component.Property;
import org.fabric3.api.model.type.component.Resource;
import org.fabric3.fabric.domain.instantiator.AtomicComponentInstantiator;
import org.fabric3.fabric.domain.instantiator.AutowireInstantiator;
import org.fabric3.fabric.domain.instantiator.ChannelInstantiator;
import org.fabric3.fabric.domain.instantiator.CompositeComponentInstantiator;
import org.fabric3.fabric.domain.instantiator.DuplicateProperty;
import org.fabric3.fabric.domain.instantiator.InstantiationContext;
import org.fabric3.fabric.domain.instantiator.LogicalModelInstantiator;
import org.fabric3.fabric.domain.instantiator.WireInstantiator;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalProperty;
import org.fabric3.spi.model.instance.LogicalResource;
import org.fabric3.spi.model.type.component.CompositeImplementation;
import org.oasisopen.sca.annotation.Constructor;
import org.oasisopen.sca.annotation.Reference;
import org.w3c.dom.Document;

public class LogicalModelInstantiatorImpl
implements LogicalModelInstantiator {
    private static final QName SYNTHETIC_COMPOSITE = new QName("urn:fabric3.org", "SyntheticComposite");
    private ChannelInstantiator channelInstantiator;
    private AtomicComponentInstantiator atomicComponentInstantiator;
    private CompositeComponentInstantiator compositeComponentInstantiator;
    private WireInstantiator wireInstantiator;
    private AutowireInstantiator autowireInstantiator;

    @Constructor
    public LogicalModelInstantiatorImpl(@Reference CompositeComponentInstantiator compositeComponentInstantiator, @Reference AtomicComponentInstantiator atomicComponentInstantiator, @Reference WireInstantiator wireInstantiator, @Reference AutowireInstantiator autowireInstantiator, @Reference ChannelInstantiator channelInstantiator) {
        this.channelInstantiator = channelInstantiator;
        this.atomicComponentInstantiator = atomicComponentInstantiator;
        this.compositeComponentInstantiator = compositeComponentInstantiator;
        this.wireInstantiator = wireInstantiator;
        this.autowireInstantiator = autowireInstantiator;
    }

    public LogicalModelInstantiatorImpl(CompositeComponentInstantiator compositeComponentInstantiator, AtomicComponentInstantiator atomicComponentInstantiator, WireInstantiator wireInstantiator, AutowireInstantiator autowireInstantiator) {
        this(compositeComponentInstantiator, atomicComponentInstantiator, wireInstantiator, autowireInstantiator, null);
    }

    @Override
    public InstantiationContext include(Composite composite, LogicalCompositeComponent domain) {
        return this.include(domain, composite, false);
    }

    @Override
    public InstantiationContext include(List<Composite> composites, LogicalCompositeComponent domain) {
        Composite composite = this.synthesizeComposite(composites);
        return this.include(domain, composite, true);
    }

    private InstantiationContext include(LogicalCompositeComponent domain, Composite composite, boolean synthetic) {
        InstantiationContext context = new InstantiationContext();
        this.includeProperties(composite, domain, context);
        this.includeResources(composite, domain, synthetic);
        this.instantiate(composite, domain, synthetic, context);
        if (domain.isAutowire()) {
            for (LogicalComponent<?> component : domain.getComponents()) {
                this.autowireInstantiator.instantiate(component, context);
            }
        }
        return context;
    }

    private void includeProperties(Composite composite, LogicalCompositeComponent domain, InstantiationContext context) {
        for (Property property : composite.getProperties().values()) {
            this.includeProperty(property, domain, context);
        }
        for (Include include : composite.getIncludes().values()) {
            for (Property property : include.getIncluded().getProperties().values()) {
                this.includeProperty(property, domain, context);
            }
        }
    }

    private void includeProperty(Property property, LogicalCompositeComponent domain, InstantiationContext context) {
        String name = property.getName();
        if (domain.getAllProperties().containsKey(name)) {
            DuplicateProperty error = new DuplicateProperty(name, domain);
            context.addError(error);
        } else {
            Document value = property.getDefaultValue();
            boolean many = property.isMany();
            QName type = property.getType();
            LogicalProperty logicalProperty = LogicalProperty.Builder.newBuilder(name, domain).xmlValue(value).many(many).type(type).build();
            domain.setProperties(logicalProperty);
        }
    }

    private void includeResources(Composite composite, LogicalCompositeComponent domain, boolean synthetic) {
        if (synthetic) {
            for (Include include : composite.getIncludes().values()) {
                Composite included = include.getIncluded();
                for (Resource definition : included.getResources()) {
                    LogicalResource<Resource> resource = new LogicalResource<Resource>(definition, domain);
                    domain.addResource(resource);
                }
            }
        } else {
            for (Resource definition : composite.getResources()) {
                LogicalResource<Resource> resource = new LogicalResource<Resource>(definition, domain);
                domain.addResource(resource);
            }
        }
    }

    private void instantiate(Composite composite, LogicalCompositeComponent domain, boolean synthetic, InstantiationContext context) {
        Collection<Component<Implementation<?>>> definitions = composite.getDeclaredComponents().values();
        ArrayList newComponents = new ArrayList(definitions.size());
        for (Component<? extends Implementation<?>> component : definitions) {
            LogicalComponent<?> logicalComponent = this.instantiate(component, domain, context);
            newComponents.add(logicalComponent);
        }
        this.instantiateIncludes(composite, newComponents, synthetic, domain, context);
        this.wireInstantiator.instantiateCompositeWires(composite, domain, context);
        for (LogicalComponent logicalComponent : newComponents) {
            this.wireInstantiator.instantiateReferenceWires(logicalComponent, context);
        }
        if (this.channelInstantiator != null) {
            if (synthetic) {
                for (Include include : composite.getIncludes().values()) {
                    Composite included = include.getIncluded();
                    this.channelInstantiator.instantiateChannels(included, domain, context);
                }
            } else {
                this.channelInstantiator.instantiateChannels(composite, domain, context);
            }
        }
    }

    private LogicalComponent<?> instantiate(Component<?> definition, LogicalCompositeComponent parent, InstantiationContext context) {
        if (definition.getComponentType() instanceof Composite) {
            Component<CompositeImplementation> component = definition;
            return this.compositeComponentInstantiator.instantiate(component, parent, context);
        }
        Component<CompositeImplementation> component = definition;
        return this.atomicComponentInstantiator.instantiate(component, parent, context);
    }

    private void instantiateIncludes(Composite composite, List<LogicalComponent<?>> newComponents, boolean synthetic, LogicalCompositeComponent domain, InstantiationContext context) {
        for (Include include : composite.getIncludes().values()) {
            for (Component<? extends Implementation<?>> component : include.getIncluded().getComponents().values()) {
                LogicalComponent<?> logicalComponent = this.instantiate(component, domain, context);
                newComponents.add(logicalComponent);
                domain.addComponent(logicalComponent);
            }
        }
    }

    private Composite synthesizeComposite(List<Composite> composites) {
        Composite synthesized = new Composite(SYNTHETIC_COMPOSITE);
        HashMap<QName, AtomicInteger> counters = new HashMap<QName, AtomicInteger>();
        for (Composite composite : composites) {
            Include include = new Include();
            QName name = composite.getName();
            include.setName(name);
            include.setIncluded(composite);
            if (synthesized.getIncludes().containsKey(name)) {
                AtomicInteger counter = (AtomicInteger)counters.get(name);
                if (counter == null) {
                    counter = new AtomicInteger();
                    counters.put(name, counter);
                }
                include.setName(new QName(name.getNamespaceURI(), name.getLocalPart() + counter.incrementAndGet()));
            }
            synthesized.add(include);
        }
        return synthesized;
    }
}

