/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.instantiator.channel;

import java.net.URI;
import org.fabric3.api.model.type.component.Binding;
import org.fabric3.api.model.type.component.Channel;
import org.fabric3.api.model.type.component.Composite;
import org.fabric3.fabric.domain.instantiator.ChannelInstantiator;
import org.fabric3.fabric.domain.instantiator.InstantiationContext;
import org.fabric3.fabric.domain.instantiator.channel.DuplicateChannel;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalChannel;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;

public class ChannelInstantiatorImpl
implements ChannelInstantiator {
    @Override
    public void instantiateChannels(Composite composite, LogicalCompositeComponent parent, InstantiationContext context) {
        for (Channel definition : composite.getChannels().values()) {
            URI uri = URI.create(parent.getUri() + "/" + definition.getName());
            if (parent.getChannel(uri) != null) {
                DuplicateChannel error = new DuplicateChannel(uri, parent);
                context.addError(error);
                continue;
            }
            LogicalChannel channel = new LogicalChannel(uri, definition, parent);
            for (Binding binding : definition.getBindings()) {
                LogicalBinding<Binding> logicalBinding = new LogicalBinding<Binding>(binding, channel);
                channel.addBinding(logicalBinding);
            }
            channel.setDeployable(composite.getName());
            parent.addChannel(channel);
        }
    }
}

