/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.instantiator.wire;

import java.net.URI;
import java.util.List;
import org.fabric3.api.model.type.component.Component;
import org.fabric3.api.model.type.component.ComponentType;
import org.fabric3.api.model.type.component.Multiplicity;
import org.fabric3.api.model.type.component.Target;
import org.fabric3.fabric.domain.instantiator.AutowireInstantiator;
import org.fabric3.fabric.domain.instantiator.InstantiationContext;
import org.fabric3.fabric.domain.instantiator.ReferenceNotFound;
import org.fabric3.fabric.domain.instantiator.wire.AutowireResolver;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.model.instance.LogicalWire;
import org.oasisopen.sca.annotation.Reference;

public class AutowireInstantiatorImpl
implements AutowireInstantiator {
    private AutowireResolver resolver;

    public AutowireInstantiatorImpl(@Reference AutowireResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public void instantiate(LogicalComponent<?> component, InstantiationContext context) {
        this.resolveReferences(component, context);
        if (component instanceof LogicalCompositeComponent) {
            LogicalCompositeComponent compositeComponent = (LogicalCompositeComponent)component;
            for (LogicalComponent<?> child : compositeComponent.getComponents()) {
                this.instantiate(child, context);
            }
        }
    }

    private void resolveReferences(LogicalComponent<?> component, InstantiationContext context) {
        LogicalCompositeComponent parent = (LogicalCompositeComponent)component.getParent();
        for (LogicalReference reference : component.getReferences()) {
            boolean refMultiplicity;
            if (reference.isBound()) continue;
            Multiplicity multiplicityValue = reference.getDefinition().getMultiplicity();
            boolean bl = refMultiplicity = multiplicityValue.equals((Object)Multiplicity.ZERO_N) || multiplicityValue.equals((Object)Multiplicity.ONE_N);
            if (!refMultiplicity && reference.isResolved()) continue;
            reference.setResolved(false);
            this.resolveReference(reference, parent, context);
        }
    }

    private void resolveReference(LogicalReference logicalReference, LogicalCompositeComponent compositeComponent, InstantiationContext context) {
        boolean targeted;
        List<Target> targets;
        org.fabric3.api.model.type.component.Reference<Component> componentReference = logicalReference.getComponentReference();
        LogicalComponent component = (LogicalComponent)logicalReference.getParent();
        org.fabric3.api.model.type.component.Reference<ComponentType> reference = logicalReference.getDefinition();
        if (componentReference == null) {
            targets = reference.getTargets();
            if (!targets.isEmpty()) {
                return;
            }
            if (logicalReference.isResolved()) {
                return;
            }
            this.instantiateWires(logicalReference, compositeComponent);
        } else if (componentReference != null) {
            targets = componentReference.getTargets();
            if (!targets.isEmpty()) {
                return;
            }
            boolean resolved = this.instantiateWires(logicalReference, (LogicalCompositeComponent)component.getParent());
            if (!resolved) {
                this.instantiateWires(logicalReference, compositeComponent);
            }
        }
        boolean bl = targeted = !logicalReference.getWires().isEmpty();
        if (!targeted && reference.isRequired() && !logicalReference.isBound()) {
            String referenceUri = logicalReference.getUri().toString();
            ReferenceNotFound error = new ReferenceNotFound("Unable to resolve reference " + referenceUri, logicalReference);
            context.addError(error);
        } else if (targeted) {
            logicalReference.setResolved(true);
        }
    }

    private boolean instantiateWires(LogicalReference logicalReference, LogicalCompositeComponent composite) {
        List<LogicalService> candidates = this.resolver.resolve(logicalReference, composite);
        if (candidates.isEmpty()) {
            return false;
        }
        LogicalComponent parent = (LogicalComponent)logicalReference.getParent();
        LogicalCompositeComponent parentComposite = (LogicalCompositeComponent)parent.getParent();
        List<LogicalWire> existingWires = parentComposite.getWires(logicalReference);
        for (LogicalService target : candidates) {
            URI contributionUri = ((LogicalComponent)target.getParent()).getDefinition().getContributionUri();
            boolean skip = false;
            for (LogicalWire existingWire : existingWires) {
                if (!target.equals(existingWire.getTarget())) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            LogicalWire wire = new LogicalWire(parentComposite, logicalReference, target, contributionUri);
            parentComposite.addWire(logicalReference, wire);
            for (LogicalWire existingWire : existingWires) {
                if (LogicalState.PROVISIONED != ((LogicalComponent)existingWire.getTarget().getParent()).getState()) continue;
                existingWire.setState(LogicalState.NEW);
            }
        }
        return true;
    }
}

