/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.instantiator.wire;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.fabric3.api.model.type.component.Binding;
import org.fabric3.api.model.type.component.Component;
import org.fabric3.api.model.type.component.ComponentType;
import org.fabric3.api.model.type.component.Composite;
import org.fabric3.api.model.type.component.Reference;
import org.fabric3.api.model.type.component.Target;
import org.fabric3.api.model.type.component.Wire;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.fabric.domain.instantiator.AmbiguousService;
import org.fabric3.fabric.domain.instantiator.InstantiationContext;
import org.fabric3.fabric.domain.instantiator.NoServiceOnComponent;
import org.fabric3.fabric.domain.instantiator.ServiceNotFound;
import org.fabric3.fabric.domain.instantiator.WireInstantiator;
import org.fabric3.fabric.domain.instantiator.wire.BindingNotFound;
import org.fabric3.fabric.domain.instantiator.wire.IncompatibleContracts;
import org.fabric3.fabric.domain.instantiator.wire.KeyNotFound;
import org.fabric3.fabric.domain.instantiator.wire.TargetComponentNotFound;
import org.fabric3.fabric.domain.instantiator.wire.WireSourceAmbiguousReference;
import org.fabric3.fabric.domain.instantiator.wire.WireSourceNoReference;
import org.fabric3.fabric.domain.instantiator.wire.WireSourceNotFound;
import org.fabric3.fabric.domain.instantiator.wire.WireSourceReferenceNotFound;
import org.fabric3.spi.contract.ContractMatcher;
import org.fabric3.spi.contract.MatchResult;
import org.fabric3.spi.model.instance.LogicalBindable;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.model.instance.LogicalWire;

public class WireInstantiatorImpl
implements WireInstantiator {
    private ContractMatcher matcher;

    public WireInstantiatorImpl(@org.oasisopen.sca.annotation.Reference ContractMatcher matcher) {
        this.matcher = matcher;
    }

    @Override
    public void instantiateCompositeWires(Composite composite, LogicalCompositeComponent parent, InstantiationContext context) {
        for (Wire definition : composite.getWires()) {
            Target serviceTarget;
            LogicalService service;
            Target referenceTarget = definition.getReferenceTarget();
            LogicalReference reference = this.resolveReference(referenceTarget, parent, context);
            if (reference == null || (service = this.resolveService(reference, serviceTarget = definition.getServiceTarget(), parent, context)) == null) continue;
            URI contributionUri = parent.getDefinition().getContributionUri();
            LogicalWire wire = new LogicalWire(parent, reference, service, contributionUri);
            String referenceBindingName = referenceTarget.getBinding();
            String serviceBindingName = serviceTarget.getBinding();
            this.resolveBindings(reference, referenceBindingName, service, wire, serviceBindingName, context);
            parent.addWire(reference, wire);
        }
    }

    @Override
    public void instantiateReferenceWires(LogicalComponent<?> component, InstantiationContext context) {
        for (LogicalReference logicalReference : component.getReferences()) {
            this.instantiateReferenceWires(logicalReference, context);
        }
    }

    private void instantiateReferenceWires(LogicalReference reference, InstantiationContext context) {
        List<Target> serviceTargets;
        LogicalCompositeComponent parent = (LogicalCompositeComponent)((LogicalComponent)reference.getParent()).getParent();
        Reference<Component> componentReference = reference.getComponentReference();
        Reference<ComponentType> definition = reference.getDefinition();
        if (componentReference == null && definition.getTargets().isEmpty()) {
            return;
        }
        List<Target> list = serviceTargets = componentReference != null ? componentReference.getTargets() : definition.getTargets();
        if (serviceTargets.isEmpty()) {
            serviceTargets = definition.getTargets();
        }
        if (serviceTargets.isEmpty()) {
            return;
        }
        ArrayList<LogicalWire> wires = new ArrayList<LogicalWire>();
        for (Target target : serviceTargets) {
            LogicalWire wire = this.createWire(target, reference, null, parent, context);
            if (wire == null) continue;
            wires.add(wire);
        }
        if (!wires.isEmpty()) {
            parent.addWires(reference, wires);
        }
        reference.setResolved(true);
    }

    private LogicalWire createWire(Target target, LogicalReference reference, String bindingName, LogicalCompositeComponent parent, InstantiationContext context) {
        LogicalService service = this.resolveService(reference, target, parent, context);
        if (service == null) {
            return null;
        }
        URI contributionUri = ((LogicalComponent)service.getParent()).getDefinition().getContributionUri();
        LogicalWire wire = new LogicalWire(parent, reference, service, contributionUri);
        String serviceBindingName = target.getBinding();
        this.resolveBindings(reference, bindingName, service, wire, serviceBindingName, context);
        return wire;
    }

    private LogicalReference resolveReference(Target target, LogicalCompositeComponent parent, InstantiationContext context) {
        LogicalReference logicalReference;
        String base = parent.getUri().toString();
        URI componentUri = URI.create(base + "/" + target.getComponent());
        String referenceName = target.getBindable();
        LogicalComponent<?> source = parent.getComponent(componentUri);
        if (source == null) {
            this.raiseWireSourceNotFound(componentUri, parent, context);
            return null;
        }
        if (referenceName == null) {
            if (source.getReferences().size() == 0) {
                this.raiseWireSourceNoReference(componentUri, parent, context);
                return null;
            }
            if (source.getReferences().size() != 1) {
                this.raiseWireSourceAmbiguousReference(componentUri, parent, context);
                return null;
            }
            logicalReference = source.getReferences().iterator().next();
        } else {
            logicalReference = source.getReference(referenceName);
            if (logicalReference == null) {
                this.raiseWireSourceNotFound(componentUri, referenceName, parent, context);
                return null;
            }
        }
        return logicalReference;
    }

    private LogicalService resolveService(LogicalReference reference, Target target, LogicalCompositeComponent parent, InstantiationContext context) {
        URI targetComponentUri = URI.create(parent.getUri().toString() + "/" + target.getComponent());
        LogicalComponent<?> targetComponent = parent.getComponent(targetComponentUri);
        if (targetComponent == null) {
            TargetComponentNotFound error = new TargetComponentNotFound(reference, targetComponentUri);
            context.addError(error);
            return null;
        }
        String serviceName = target.getBindable();
        LogicalService targetService = null;
        if (serviceName != null) {
            targetService = targetComponent.getService(serviceName);
            if (targetService == null) {
                this.raiseServiceNotFound(reference, target, context);
                return null;
            }
        } else {
            if (targetComponent.getServices().isEmpty()) {
                this.raiseNoService(reference, target, parent, context);
                return null;
            }
            if (targetComponent.getServices().size() == 1) {
                targetService = targetComponent.getServices().iterator().next();
            } else {
                for (LogicalService service : targetComponent.getServices()) {
                    if (!this.matcher.isAssignableFrom(reference.getServiceContract(), service.getServiceContract(), false).isAssignable()) continue;
                    return service;
                }
                this.raiseAmbiguousService(reference, target, context);
                return null;
            }
        }
        this.validate(reference, targetService, context);
        return targetService;
    }

    private void resolveBindings(LogicalReference reference, String referenceBindingName, LogicalService service, LogicalWire wire, String serviceBindingName, InstantiationContext context) {
        LogicalBinding<?> referenceBinding;
        if (serviceBindingName == null) {
            return;
        }
        LogicalBinding<?> serviceBinding = this.getBinding(serviceBindingName, service);
        if (serviceBinding == null) {
            this.raiseServiceBindingNotFound(service, serviceBindingName, context);
        }
        if (referenceBindingName != null) {
            referenceBinding = this.getBinding(referenceBindingName, reference);
        } else if (serviceBinding != null) {
            referenceBinding = this.selectBinding(reference, serviceBinding);
        } else {
            return;
        }
        wire.setSourceBinding(referenceBinding);
        wire.setTargetBinding(serviceBinding);
        if (serviceBinding != null && referenceBinding != null && !((Binding)referenceBinding.getDefinition()).getType().equals(((Binding)serviceBinding.getDefinition()).getType())) {
            this.raiseIncompatibleBindings(reference, service, referenceBindingName, context);
        }
    }

    private LogicalBinding<?> selectBinding(LogicalBindable bindable, LogicalBinding binding) {
        for (LogicalBinding<?> candidate : bindable.getBindings()) {
            if (!((Binding)candidate.getDefinition()).getType().equals(((Binding)binding.getDefinition()).getType())) continue;
            return candidate;
        }
        return null;
    }

    private LogicalBinding<?> getBinding(String name, LogicalBindable bindable) {
        LogicalBinding<?> selectedBinding = null;
        for (LogicalBinding<?> binding : bindable.getBindings()) {
            if (!name.equals(((Binding)binding.getDefinition()).getName())) continue;
            selectedBinding = binding;
            break;
        }
        return selectedBinding;
    }

    private void validate(LogicalReference reference, LogicalService service, InstantiationContext context) {
        this.validateKeyedReference(reference, service, context);
        this.validateContracts(reference, service, context);
    }

    private void validateKeyedReference(LogicalReference reference, LogicalService service, InstantiationContext context) {
        if (!reference.getDefinition().isKeyed()) {
            return;
        }
        LogicalComponent parent = (LogicalComponent)service.getParent();
        if (parent.getDefinition().getKey() == null && parent.getDefinition().getComponentType().getKey() == null) {
            KeyNotFound error = new KeyNotFound(reference);
            context.addError(error);
        }
    }

    private void validateContracts(LogicalReference reference, LogicalService service, InstantiationContext context) {
        ServiceContract serviceContract;
        ServiceContract referenceContract = reference.getServiceContract();
        MatchResult result = this.matcher.isAssignableFrom(referenceContract, serviceContract = service.getServiceContract(), true);
        if (!result.isAssignable()) {
            URI serviceUri = service.getUri();
            String message = result.getError();
            IncompatibleContracts error = new IncompatibleContracts(reference, serviceUri, message);
            context.addError(error);
        }
    }

    private void raiseWireSourceNotFound(URI componentUri, String referenceName, LogicalCompositeComponent parent, InstantiationContext context) {
        WireSourceReferenceNotFound error = new WireSourceReferenceNotFound(componentUri, referenceName, parent);
        context.addError(error);
    }

    private void raiseWireSourceAmbiguousReference(URI componentUri, LogicalCompositeComponent parent, InstantiationContext context) {
        WireSourceAmbiguousReference error = new WireSourceAmbiguousReference(componentUri, parent);
        context.addError(error);
    }

    private void raiseWireSourceNoReference(URI componentUri, LogicalCompositeComponent parent, InstantiationContext context) {
        WireSourceNoReference error = new WireSourceNoReference(componentUri, parent);
        context.addError(error);
    }

    private void raiseWireSourceNotFound(URI componentUri, LogicalCompositeComponent parent, InstantiationContext context) {
        WireSourceNotFound error = new WireSourceNotFound(componentUri, parent);
        context.addError(error);
    }

    private void raiseNoService(LogicalReference reference, Target target, LogicalCompositeComponent parent, InstantiationContext context) {
        String componentName = target.getComponent();
        URI referenceUri = reference.getUri();
        String msg = "The reference " + referenceUri + " is wired to component " + componentName + " but the component has no services";
        NoServiceOnComponent error = new NoServiceOnComponent(msg, parent);
        context.addError(error);
    }

    private void raiseAmbiguousService(LogicalReference reference, Target target, InstantiationContext context) {
        String componentName = target.getComponent();
        URI referenceUri = reference.getUri();
        String msg = "More than one service available on component: " + componentName + ". The wire from the reference " + referenceUri + " must explicitly specify a target service.";
        AmbiguousService error = new AmbiguousService(msg, reference);
        context.addError(error);
    }

    private void raiseServiceNotFound(LogicalReference reference, Target target, InstantiationContext context) {
        URI referenceUri = reference.getUri();
        String componentName = target.getComponent();
        String serviceName = target.getBindable();
        String msg = "The service " + serviceName + " wired from the reference " + referenceUri + " is not found on component " + componentName;
        ServiceNotFound error = new ServiceNotFound(msg, reference);
        context.addError(error);
    }

    private void raiseServiceBindingNotFound(LogicalService service, String name, InstantiationContext context) {
        BindingNotFound error = new BindingNotFound("The binding " + name + "  for service " + service.getUri() + " was not found", service);
        context.addError(error);
    }

    private void raiseIncompatibleBindings(LogicalReference reference, LogicalService service, String name, InstantiationContext context) {
        BindingNotFound error = new BindingNotFound("The binding " + name + " for reference " + reference.getUri() + " and service " + service.getUri() + " are not compatible", reference);
        context.addError(error);
    }
}

