/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.node;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.model.type.component.Component;
import org.fabric3.api.model.type.component.Producer;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.api.node.NotFoundException;
import org.fabric3.fabric.container.builder.ChannelConnector;
import org.fabric3.fabric.container.builder.channel.ChannelBuilderRegistry;
import org.fabric3.fabric.domain.LogicalComponentManager;
import org.fabric3.fabric.domain.generator.channel.ChannelDirection;
import org.fabric3.fabric.domain.generator.channel.ChannelGenerator;
import org.fabric3.fabric.domain.generator.channel.ConnectionGenerator;
import org.fabric3.fabric.node.ContributionResolver;
import org.fabric3.fabric.node.Introspector;
import org.fabric3.fabric.node.nonmanaged.NonManagedConnectionSource;
import org.fabric3.fabric.node.nonmanaged.NonManagedConnectionTarget;
import org.fabric3.fabric.node.nonmanaged.NonManagedImplementation;
import org.fabric3.spi.container.channel.ChannelConnection;
import org.fabric3.spi.container.channel.ChannelResolver;
import org.fabric3.spi.model.instance.LogicalChannel;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalConsumer;
import org.fabric3.spi.model.instance.LogicalProducer;
import org.fabric3.spi.model.physical.DeliveryType;
import org.fabric3.spi.model.physical.PhysicalChannel;
import org.fabric3.spi.model.physical.PhysicalChannelConnection;
import org.fabric3.spi.model.type.java.JavaServiceContract;
import org.fabric3.spi.model.type.java.JavaType;
import org.fabric3.spi.util.Closeable;
import org.oasisopen.sca.annotation.Reference;

public class ChannelResolverImpl
implements ChannelResolver {
    private static final URI SYNTHETIC_CONTRIBUTION = URI.create("SyntheticContribution");
    private Introspector introspector;
    private LogicalComponentManager lcm;
    private ChannelGenerator channelGenerator;
    private ConnectionGenerator connectionGenerator;
    private ChannelBuilderRegistry channelBuilderRegistry;
    private ChannelConnector channelConnector;
    private AtomicInteger counter = new AtomicInteger();

    public ChannelResolverImpl(@Reference Introspector introspector, @Reference(name="lcm") LogicalComponentManager lcm, @Reference ChannelGenerator channelGenerator, @Reference ConnectionGenerator connectionGenerator, @Reference ChannelBuilderRegistry channelBuilderRegistry, @Reference ChannelConnector channelConnector) {
        this.introspector = introspector;
        this.lcm = lcm;
        this.channelGenerator = channelGenerator;
        this.connectionGenerator = connectionGenerator;
        this.channelBuilderRegistry = channelBuilderRegistry;
        this.channelConnector = channelConnector;
    }

    @Override
    public <T> T getProducer(Class<T> interfaze, String name) throws Fabric3Exception {
        return this.getProducer(interfaze, name, null);
    }

    @Override
    public <T> T getProducer(Class<T> interfaze, String name, String topic) {
        LogicalChannel logicalChannel = this.getChannel(name);
        LogicalProducer producer = this.createProducer(interfaze, logicalChannel.getUri());
        PhysicalChannel physicalChannel = this.channelGenerator.generate(logicalChannel, SYNTHETIC_CONTRIBUTION, ChannelDirection.PRODUCER);
        this.channelBuilderRegistry.build(physicalChannel);
        Map<LogicalChannel, DeliveryType> channels = Collections.singletonMap(logicalChannel, DeliveryType.DEFAULT);
        List<PhysicalChannelConnection> connections = this.connectionGenerator.generateProducer(producer, channels);
        NonManagedConnectionSource source = this.connect(topic, connections);
        return interfaze.cast(source.getProxy());
    }

    @Override
    public <T> T getConsumer(Class<T> interfaze, String name) {
        return this.getConsumer(interfaze, name, null);
    }

    @Override
    public <T> T getConsumer(Class<T> interfaze, String name, String topic) {
        LogicalChannel logicalChannel = this.getChannel(name);
        LogicalConsumer consumer = this.createConsumer(interfaze, logicalChannel.getUri());
        PhysicalChannel physicalChannel = this.channelGenerator.generate(logicalChannel, SYNTHETIC_CONTRIBUTION, ChannelDirection.CONSUMER);
        this.channelBuilderRegistry.build(physicalChannel);
        Map<LogicalChannel, DeliveryType> channels = Collections.singletonMap(logicalChannel, DeliveryType.DEFAULT);
        List<PhysicalChannelConnection> connections = this.connectionGenerator.generateConsumer(consumer, channels);
        PhysicalChannelConnection connection = connections.get(0);
        connection.setTopic(topic);
        connection.getSource().setTopic(topic);
        connection.getTarget().setTopic(topic);
        this.channelConnector.connect(connection);
        NonManagedConnectionTarget target = (NonManagedConnectionTarget)connection.getTarget();
        return interfaze.cast(target.getProxy());
    }

    @Override
    public Object subscribe(Class<?> type, String name, String id, String topic, Consumer<?> consumer) {
        LogicalChannel logicalChannel = this.getChannel(name);
        LogicalConsumer logicalConsumer = this.createConsumer(type, logicalChannel.getUri());
        PhysicalChannel physicalChannel = this.channelGenerator.generate(logicalChannel, SYNTHETIC_CONTRIBUTION, ChannelDirection.CONSUMER);
        this.channelBuilderRegistry.build(physicalChannel);
        Map<LogicalChannel, DeliveryType> channels = Collections.singletonMap(logicalChannel, DeliveryType.DEFAULT);
        List<PhysicalChannelConnection> connections = this.connectionGenerator.generateConsumer(logicalConsumer, channels);
        Closeable closeable = null;
        for (PhysicalChannelConnection connection : connections) {
            connection.setTopic(topic);
            connection.getSource().setTopic(topic);
            connection.getTarget().setTopic(topic);
            connection.getTarget().setConsumer(consumer);
            ChannelConnection channelConnection = this.channelConnector.connect(connection);
            if (channelConnection.getCloseable() == null) continue;
            closeable = channelConnection.getCloseable();
        }
        return closeable;
    }

    private NonManagedConnectionSource connect(String topic, List<PhysicalChannelConnection> connections) {
        NonManagedConnectionSource source = null;
        for (PhysicalChannelConnection connection : connections) {
            connection.setTopic(topic);
            connection.getSource().setTopic(topic);
            connection.getTarget().setTopic(topic);
            this.channelConnector.connect(connection);
            if (!(connection.getSource() instanceof NonManagedConnectionSource)) continue;
            source = (NonManagedConnectionSource)connection.getSource();
        }
        if (source == null) {
            throw new Fabric3Exception("NonManagedConnectionSource not found publishing to topic: " + topic);
        }
        return source;
    }

    private <T> LogicalConsumer createConsumer(Class<T> type, URI channelUri) {
        JavaServiceContract contract = this.introspector.introspect(type);
        LogicalCompositeComponent domain = this.lcm.getDomainComposite();
        String root = domain.getUri().toString();
        LogicalComponent<NonManagedImplementation> logicalComponent = this.createComponent(Object.class, domain, root);
        JavaType dataType = new JavaType(type);
        org.fabric3.api.model.type.component.Consumer consumer = new org.fabric3.api.model.type.component.Consumer("consumer", (DataType)dataType, true);
        int pos = this.counter.getAndIncrement();
        LogicalConsumer logicalConsumer = new LogicalConsumer(URI.create(root + "/F3Synthetic#consumer" + pos), consumer, logicalComponent);
        logicalConsumer.setServiceContract(contract);
        logicalConsumer.addSource(channelUri);
        return logicalConsumer;
    }

    private LogicalChannel getChannel(String name) throws Fabric3Exception {
        String domainRoot;
        URI channelUri;
        LogicalCompositeComponent domainComponent = this.lcm.getDomainComposite();
        LogicalChannel logicalChannel = domainComponent.getChannel(channelUri = URI.create((domainRoot = domainComponent.getUri().toString()) + "/" + name));
        if (logicalChannel == null) {
            throw new NotFoundException("Channel not found: " + name);
        }
        return logicalChannel;
    }

    private <T> LogicalProducer createProducer(Class<T> interfaze, URI channelUri) throws Fabric3Exception {
        JavaServiceContract contract = this.introspector.introspect(interfaze);
        LogicalCompositeComponent domain = this.lcm.getDomainComposite();
        String root = domain.getUri().toString();
        LogicalComponent<NonManagedImplementation> logicalComponent = this.createComponent(interfaze, domain, root);
        Producer producer = new Producer("producer", contract);
        int pos = this.counter.getAndIncrement();
        LogicalProducer logicalProducer = new LogicalProducer(URI.create(root + "/F3Synthetic#producer" + pos), producer, logicalComponent);
        logicalProducer.setServiceContract(contract);
        logicalProducer.addTarget(channelUri);
        return logicalProducer;
    }

    private <T> LogicalComponent<NonManagedImplementation> createComponent(Class<T> interfaze, LogicalCompositeComponent domain, String root) {
        URI componentUri = URI.create(root + "/F3Synthetic");
        InjectingComponentType componentType = new InjectingComponentType();
        NonManagedImplementation implementation = new NonManagedImplementation();
        implementation.setComponentType(componentType);
        Component<NonManagedImplementation> component = new Component<NonManagedImplementation>("F3Synthetic");
        component.setContributionUri(ContributionResolver.getContribution(interfaze));
        component.setImplementation(implementation);
        return new LogicalComponent<NonManagedImplementation>(componentUri, component, domain);
    }
}

