/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.node;

import java.lang.reflect.AccessibleObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.component.Binding;
import org.fabric3.api.model.type.component.Consumer;
import org.fabric3.api.model.type.component.Producer;
import org.fabric3.api.model.type.component.Reference;
import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.api.model.type.java.InjectionSite;
import org.fabric3.api.node.service.InjectorFactory;
import org.fabric3.fabric.node.ServiceResolver;
import org.fabric3.spi.introspection.DefaultIntrospectionContext;
import org.fabric3.spi.introspection.TypeMapping;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.introspection.java.PostProcessor;
import org.fabric3.spi.introspection.java.annotation.ClassVisitor;
import org.fabric3.spi.model.type.java.FieldInjectionSite;
import org.fabric3.spi.model.type.java.MethodInjectionSite;

public class InjectorFactoryImpl
implements InjectorFactory {
    private ClassVisitor classVisitor;
    private ServiceResolver serviceResolver;
    private IntrospectionHelper introspectionHelper;
    private List<PostProcessor> postProcessors = Collections.emptyList();

    @org.oasisopen.sca.annotation.Reference(required=false)
    public void setPostProcessors(List<PostProcessor> postProcessors) {
        this.postProcessors = postProcessors;
    }

    public InjectorFactoryImpl(@org.oasisopen.sca.annotation.Reference ClassVisitor classVisitor, @org.oasisopen.sca.annotation.Reference ServiceResolver serviceResolver, @org.oasisopen.sca.annotation.Reference IntrospectionHelper helper) {
        this.classVisitor = classVisitor;
        this.serviceResolver = serviceResolver;
        this.introspectionHelper = helper;
    }

    @Override
    public Map<AccessibleObject, Supplier<Object>> getInjectors(Class<?> clazz) {
        HashMap<AccessibleObject, Supplier<Object>> injectors = new HashMap<AccessibleObject, Supplier<Object>>();
        InjectingComponentType componentType = new InjectingComponentType(clazz);
        DefaultIntrospectionContext context = new DefaultIntrospectionContext();
        TypeMapping typeMapping = new TypeMapping();
        context.addTypeMapping(clazz, typeMapping);
        this.introspectionHelper.resolveTypeParameters(clazz, typeMapping);
        this.classVisitor.visit(componentType, clazz, context);
        for (PostProcessor postProcessor : this.postProcessors) {
            postProcessor.process(componentType, clazz, context);
        }
        for (Map.Entry entry : componentType.getInjectionSiteMappings().entrySet()) {
            ModelObject key = (ModelObject)entry.getKey();
            InjectionSite value = (InjectionSite)entry.getValue();
            if (key instanceof Reference) {
                Reference reference = (Reference)key;
                this.handleReference(reference, value, clazz, injectors);
                continue;
            }
            if (key instanceof Producer) {
                Producer producer = (Producer)key;
                throw new UnsupportedOperationException("Not yet implemented");
            }
            if (!(key instanceof Consumer)) continue;
            throw new UnsupportedOperationException("Not yet implemented");
        }
        return injectors;
    }

    private void handleReference(Reference<?> reference, InjectionSite site, Class<?> implClass, Map<AccessibleObject, Supplier<Object>> injectors) {
        AccessibleObject accessibleObject;
        if (reference.getBindings().isEmpty()) {
            return;
        }
        Class<?> interfaze = reference.getServiceContract().getInterfaceClass();
        Binding binding = reference.getBindings().get(0);
        if (site instanceof FieldInjectionSite) {
            accessibleObject = ((FieldInjectionSite)site).getField();
        } else if (site instanceof MethodInjectionSite) {
            accessibleObject = ((MethodInjectionSite)site).getMethod();
        } else {
            return;
        }
        injectors.put(accessibleObject, () -> this.serviceResolver.resolve(interfaze, binding, implClass));
    }
}

