/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.node;

import java.net.URI;
import java.util.List;
import javax.xml.namespace.QName;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.domain.Domain;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.builder.JavaComponentBuilder;
import org.fabric3.api.model.type.component.Channel;
import org.fabric3.api.model.type.component.Component;
import org.fabric3.api.model.type.component.ComponentType;
import org.fabric3.api.model.type.component.Composite;
import org.fabric3.api.model.type.component.Implementation;
import org.fabric3.api.model.type.component.Service;
import org.fabric3.api.model.type.java.JavaImplementation;
import org.fabric3.fabric.node.ContributionResolver;
import org.fabric3.fabric.node.Provisioner;
import org.fabric3.fabric.node.ValidationDeploymentException;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.contribution.ResourceElement;
import org.fabric3.spi.contribution.ResourceState;
import org.fabric3.spi.contribution.manifest.QNameSymbol;
import org.fabric3.spi.introspection.DefaultIntrospectionContext;
import org.fabric3.spi.introspection.java.ComponentProcessor;
import org.fabric3.spi.introspection.java.contract.JavaContractProcessor;
import org.fabric3.spi.model.type.java.JavaServiceContract;
import org.oasisopen.sca.annotation.Reference;

public class ProvisionerImpl
implements Provisioner {
    private JavaContractProcessor contractProcessor;
    private ComponentProcessor componentProcessor;
    private MetaDataStore metaDataStore;
    private Domain domain;

    public ProvisionerImpl(@Reference JavaContractProcessor contractProcessor, @Reference ComponentProcessor componentProcessor, @Reference MetaDataStore metaDataStore, @Reference(name="domain") Domain domain) {
        this.contractProcessor = contractProcessor;
        this.componentProcessor = componentProcessor;
        this.metaDataStore = metaDataStore;
        this.domain = domain;
    }

    @Override
    public void deploy(String name, Object instance, Class<?> ... interfaces) throws Fabric3Exception {
        Component<JavaImplementation> definition = JavaComponentBuilder.newBuilder(name, instance).build();
        if (interfaces == null) {
            Class<?>[] implementedInterfaces = this.getClass().getInterfaces();
            if (implementedInterfaces.length == 0) {
                this.addService(instance.getClass(), definition);
            } else {
                for (Class<?> interfaze : implementedInterfaces) {
                    this.addService(interfaze, definition);
                }
            }
        } else {
            for (Class<?> interfaze : interfaces) {
                this.addService(interfaze, definition);
            }
        }
        this.deploy(definition);
    }

    @Override
    public void deploy(Composite composite) throws Fabric3Exception {
        DefaultIntrospectionContext context = new DefaultIntrospectionContext(ContributionResolver.getContribution(), this.getClass().getClassLoader());
        for (Component<? extends Implementation<?>> component : composite.getComponents().values()) {
            this.componentProcessor.process(component, context);
        }
        this.checkErrors(context);
        this.setContributionUris(composite);
        this.addCompositeToContribution(composite);
        this.domain.include(composite);
    }

    @Override
    public void deploy(Component<?> component) throws Fabric3Exception {
        URI uri = ContributionResolver.getContribution();
        DefaultIntrospectionContext context = new DefaultIntrospectionContext(uri, this.getClass().getClassLoader());
        component.setContributionUri(uri);
        this.componentProcessor.process(component, context);
        this.checkErrors(context);
        Composite wrapper = this.createWrapperComposite(component.getName());
        wrapper.add(component);
        this.domain.include(wrapper);
    }

    @Override
    public void deploy(Channel channel) throws Fabric3Exception {
        Composite wrapper = this.createWrapperComposite(channel.getName());
        wrapper.add(channel);
        this.domain.include(wrapper);
    }

    @Override
    public void undeploy(QName name) throws Fabric3Exception {
        QNameSymbol symbol = new QNameSymbol(name);
        ResourceElement<QNameSymbol, Composite> element = this.metaDataStore.find(Composite.class, symbol);
        if (element == null) {
            throw new Fabric3Exception("Component not deployed: " + name);
        }
        Composite composite = element.getValue();
        this.domain.undeploy(composite);
        Resource resource = element.getResource();
        Contribution contribution = resource.getContribution();
        contribution.getResources().remove(resource);
    }

    @Override
    public void undeploy(String name) throws Fabric3Exception {
        QName compositeName = new QName("urn:fabric3.org:synthesized", name);
        this.undeploy(compositeName);
    }

    private Composite createWrapperComposite(String name) {
        QName compositeName = new QName("urn:fabric3.org:synthesized", name);
        Composite wrapper = new Composite(compositeName);
        URI uri = ContributionResolver.getContribution();
        wrapper.setContributionUri(uri);
        this.addCompositeToContribution(wrapper);
        return wrapper;
    }

    private void addCompositeToContribution(Composite wrapper) {
        QName compositeName = wrapper.getName();
        URI uri = ContributionResolver.getContribution();
        Contribution contribution = this.metaDataStore.find(uri);
        Resource resource = new Resource(contribution, null, "text/vnd.fabric3.composite+xml");
        QNameSymbol symbol = new QNameSymbol(compositeName);
        ResourceElement<QNameSymbol, Composite> element = new ResourceElement<QNameSymbol, Composite>(symbol, wrapper);
        resource.addResourceElement(element);
        resource.setState(ResourceState.PROCESSED);
        contribution.addResource(resource);
    }

    private void addService(Class<?> interfaze, Component<?> definition) throws ValidationDeploymentException {
        URI uri = ContributionResolver.getContribution();
        DefaultIntrospectionContext context = new DefaultIntrospectionContext(uri, this.getClass().getClassLoader());
        JavaServiceContract contract = this.contractProcessor.introspect(interfaze, context, new ModelObject[0]);
        Service<ComponentType> service = new Service<ComponentType>(interfaze.getSimpleName(), contract);
        definition.getComponentType().add(service);
        this.checkErrors(context);
    }

    private void checkErrors(DefaultIntrospectionContext context) throws ValidationDeploymentException {
        List<ValidationFailure> errors = context.getErrors();
        List<ValidationFailure> warnings = context.getErrors();
        if (context.hasErrors()) {
            throw new ValidationDeploymentException(errors, warnings);
        }
    }

    private void setContributionUris(Composite composite) {
        URI uri = ContributionResolver.getContribution();
        composite.setContributionUri(uri);
        for (Component<Implementation<?>> definition : composite.getComponents().values()) {
            definition.setContributionUri(uri);
            if (!(definition.getComponentType() instanceof Composite)) continue;
            this.setContributionUris((Composite)definition.getComponentType());
        }
    }
}

