/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.node;

import java.net.URI;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.namespace.QName;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.Names;
import org.fabric3.api.model.type.component.Binding;
import org.fabric3.api.model.type.component.Component;
import org.fabric3.api.model.type.component.ComponentType;
import org.fabric3.api.model.type.component.Composite;
import org.fabric3.api.model.type.component.Multiplicity;
import org.fabric3.api.model.type.component.Reference;
import org.fabric3.api.node.NotFoundException;
import org.fabric3.fabric.container.builder.Connector;
import org.fabric3.fabric.domain.LogicalComponentManager;
import org.fabric3.fabric.domain.generator.wire.WireGenerator;
import org.fabric3.fabric.domain.instantiator.wire.AutowireResolver;
import org.fabric3.fabric.node.ContributionResolver;
import org.fabric3.fabric.node.Introspector;
import org.fabric3.fabric.node.ServiceResolver;
import org.fabric3.fabric.node.nonmanaged.NonManagedImplementation;
import org.fabric3.fabric.node.nonmanaged.NonManagedWireSource;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.model.instance.LogicalWire;
import org.fabric3.spi.model.physical.PhysicalWire;
import org.fabric3.spi.model.type.java.JavaServiceContract;

public class ServiceResolverImpl
implements ServiceResolver {
    private static final URI SYNTHETIC_CONTRIBUTION = URI.create("Synthetic");
    private Introspector introspector;
    private LogicalComponentManager lcm;
    private AutowireResolver autowireResolver;
    private WireGenerator wireGenerator;
    private Connector connector;
    private ClassLoaderRegistry classLoaderRegistry;
    private AtomicInteger idCounter = new AtomicInteger();

    public ServiceResolverImpl(@org.oasisopen.sca.annotation.Reference Introspector introspector, @org.oasisopen.sca.annotation.Reference(name="lcm") LogicalComponentManager lcm, @org.oasisopen.sca.annotation.Reference AutowireResolver autowireResolver, @org.oasisopen.sca.annotation.Reference WireGenerator wireGenerator, @org.oasisopen.sca.annotation.Reference Connector connector, @org.oasisopen.sca.annotation.Reference ClassLoaderRegistry classLoaderRegistry) {
        this.introspector = introspector;
        this.lcm = lcm;
        this.autowireResolver = autowireResolver;
        this.wireGenerator = wireGenerator;
        this.connector = connector;
        this.classLoaderRegistry = classLoaderRegistry;
    }

    @Override
    public <T> T resolve(Class<T> interfaze) throws Fabric3Exception {
        LogicalWire logicalWire = this.createWire(interfaze);
        PhysicalWire physicalWire = this.wireGenerator.generateWire(logicalWire);
        NonManagedWireSource source = (NonManagedWireSource)physicalWire.getSource();
        URI uri = ContributionResolver.getContribution(interfaze);
        ClassLoader classLoader = this.classLoaderRegistry.getClassLoader(uri);
        physicalWire.getTarget().setClassLoader(classLoader);
        source.setClassLoader(classLoader);
        this.connector.connect(physicalWire);
        return interfaze.cast(source.getProxy());
    }

    @Override
    public <T> T resolve(Class<T> interfaze, Binding binding, Class<?> implClass) throws Fabric3Exception {
        LogicalReference logicalReference = this.createReference(interfaze);
        LogicalBinding<Binding> logicalBinding = new LogicalBinding<Binding>(binding, logicalReference);
        logicalReference.addBinding(logicalBinding);
        PhysicalWire physicalWire = this.wireGenerator.generateReference(logicalBinding);
        NonManagedWireSource source = (NonManagedWireSource)physicalWire.getSource();
        URI uri = ContributionResolver.getContribution(interfaze);
        ClassLoader classLoader = this.classLoaderRegistry.getClassLoader(uri);
        physicalWire.getTarget().setClassLoader(classLoader);
        source.setClassLoader(classLoader);
        this.connector.connect(physicalWire);
        return interfaze.cast(source.getProxy());
    }

    private <T> LogicalWire createWire(Class<T> interfaze) throws Fabric3Exception {
        LogicalCompositeComponent domainComponent;
        LogicalReference logicalReference = this.createReference(interfaze);
        List<LogicalService> services = this.autowireResolver.resolve(logicalReference, domainComponent = this.lcm.getDomainComposite());
        if (services.isEmpty()) {
            throw new NotFoundException("Service not found for type: " + interfaze.getName());
        }
        LogicalService targetService = services.get(0);
        return new LogicalWire(domainComponent, logicalReference, targetService, SYNTHETIC_CONTRIBUTION);
    }

    private LogicalReference createReference(Class<?> interfaze) {
        LogicalCompositeComponent domainComponent = this.lcm.getDomainComposite();
        int id = this.idCounter.getAndIncrement();
        String name = "Synthetic" + id;
        URI componentUri = URI.create(domainComponent.getUri().toString() + "/" + name);
        URI referenceUri = URI.create(componentUri.toString() + "#reference");
        QName qName = new QName("urn:fabric3.org:synthesized", "SyntheticComposite" + id);
        Composite composite = new Composite(qName);
        Component<NonManagedImplementation> component = new Component<NonManagedImplementation>(name);
        component.setParent(composite);
        component.setContributionUri(Names.HOST_CONTRIBUTION);
        NonManagedImplementation implementation = new NonManagedImplementation();
        component.setImplementation(implementation);
        Reference<ComponentType> reference = new Reference<ComponentType>("reference", Multiplicity.ONE_ONE);
        composite.add(reference);
        JavaServiceContract contract = this.introspector.introspect(interfaze);
        LogicalComponent logicalComponent = new LogicalComponent(componentUri, component, domainComponent);
        reference.setServiceContract(contract);
        LogicalReference logicalReference = new LogicalReference(referenceUri, reference, logicalComponent);
        logicalReference.setServiceContract(contract);
        logicalComponent.addReference(logicalReference);
        return logicalReference;
    }
}

