/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.runtime;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.Names;
import org.fabric3.api.host.Version;
import org.fabric3.api.host.domain.Domain;
import org.fabric3.api.host.monitor.DestinationRouter;
import org.fabric3.api.host.monitor.MonitorProxyService;
import org.fabric3.api.host.monitor.Monitorable;
import org.fabric3.api.host.runtime.BootConfiguration;
import org.fabric3.api.host.runtime.BootExports;
import org.fabric3.api.host.runtime.ComponentRegistration;
import org.fabric3.api.host.runtime.Fabric3Runtime;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.model.type.component.Composite;
import org.fabric3.contribution.manifest.ContributionExport;
import org.fabric3.fabric.container.channel.ChannelManager;
import org.fabric3.fabric.domain.LogicalComponentManager;
import org.fabric3.fabric.domain.instantiator.AtomicComponentInstantiator;
import org.fabric3.fabric.domain.instantiator.component.AtomicComponentInstantiatorImpl;
import org.fabric3.fabric.runtime.Bootstrapper;
import org.fabric3.fabric.runtime.RuntimeServices;
import org.fabric3.fabric.runtime.bootstrap.BootstrapAssemblyFactory;
import org.fabric3.fabric.runtime.bootstrap.BootstrapCompositeFactory;
import org.fabric3.fabric.runtime.bootstrap.BootstrapIntrospectionFactory;
import org.fabric3.fabric.runtime.bootstrap.Java6HostExports;
import org.fabric3.fabric.synthesizer.ComponentSynthesizer;
import org.fabric3.fabric.synthesizer.SingletonComponentSynthesizer;
import org.fabric3.introspection.java.DefaultIntrospectionHelper;
import org.fabric3.introspection.java.contract.JavaContractProcessorImpl;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.container.component.ComponentManager;
import org.fabric3.spi.container.component.ScopeContainer;
import org.fabric3.spi.container.component.ScopeRegistry;
import org.fabric3.spi.contribution.Capability;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ContributionManifest;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.contribution.manifest.JavaExport;
import org.fabric3.spi.contribution.manifest.PackageInfo;
import org.fabric3.spi.introspection.java.ImplementationIntrospector;
import org.fabric3.spi.introspection.java.contract.JavaContractProcessor;
import org.fabric3.spi.management.ManagementService;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalProperty;
import org.w3c.dom.Document;

public class DefaultBootstrapper
implements Bootstrapper {
    private static final URI RUNTIME_SERVICES = URI.create("fabric3://RuntimeServices");
    private JavaContractProcessorImpl contractProcessor;
    private AtomicComponentInstantiatorImpl instantiator;
    private ImplementationIntrospector implementationIntrospector;
    private ComponentSynthesizer synthesizer;
    private MonitorProxyService monitorService;
    private ClassLoaderRegistry classLoaderRegistry;
    private MetaDataStore metaDataStore;
    private ScopeRegistry scopeRegistry;
    private LogicalCompositeComponent domain;
    private LogicalComponentManager lcm;
    private ComponentManager componentManager;
    private ChannelManager channelManager;
    private ScopeContainer scopeContainer;
    private MBeanServer mbeanServer;
    private ManagementService managementService;
    private HostInfo hostInfo;
    private Domain runtimeDomain;
    private Fabric3Runtime runtime;
    private Document systemConfig;
    private ClassLoader bootClassLoader;
    private Map<String, String> exportedPackages;
    private List<String> hostCapabilities;
    private ClassLoader hostClassLoader;
    private Contribution bootContribution;
    private List<ComponentRegistration> registrations;
    private DestinationRouter router;

    public DefaultBootstrapper(BootConfiguration configuration) {
        this.runtime = configuration.getRuntime();
        this.systemConfig = configuration.getSystemConfig();
        this.hostClassLoader = configuration.getHostClassLoader();
        this.bootClassLoader = configuration.getBootClassLoader();
        this.exportedPackages = configuration.getExportedPackages();
        this.hostCapabilities = configuration.getHostCapabilities();
        this.registrations = configuration.getRegistrations();
        DefaultIntrospectionHelper helper = new DefaultIntrospectionHelper();
        this.contractProcessor = new JavaContractProcessorImpl(helper);
        this.instantiator = new AtomicComponentInstantiatorImpl();
        this.implementationIntrospector = BootstrapIntrospectionFactory.createSystemImplementationProcessor();
    }

    @Override
    public void bootRuntimeDomain() throws Fabric3Exception {
        RuntimeServices runtimeServices = this.runtime.getComponent(RuntimeServices.class, RUNTIME_SERVICES);
        this.hostInfo = runtimeServices.getHostInfo();
        this.monitorService = runtimeServices.getMonitorProxyService();
        this.router = runtimeServices.getDestinationRouter();
        this.lcm = runtimeServices.getLogicalComponentManager();
        this.componentManager = runtimeServices.getComponentManager();
        this.channelManager = runtimeServices.getChannelManager();
        this.domain = this.lcm.getDomainComposite();
        this.classLoaderRegistry = runtimeServices.getClassLoaderRegistry();
        this.metaDataStore = runtimeServices.getMetaDataStore();
        this.scopeRegistry = runtimeServices.getScopeRegistry();
        this.scopeContainer = runtimeServices.getScopeContainer();
        this.mbeanServer = runtimeServices.getMBeanServer();
        this.managementService = runtimeServices.getManagementService();
        this.hostInfo = runtimeServices.getHostInfo();
        this.synthesizer = new SingletonComponentSynthesizer(this.implementationIntrospector, (AtomicComponentInstantiator)this.instantiator, this.lcm, this.componentManager, (JavaContractProcessor)this.contractProcessor, this.scopeContainer);
        this.registerRuntimeComponents(this.registrations);
        this.runtimeDomain = BootstrapAssemblyFactory.createDomain(this.monitorService, this.classLoaderRegistry, this.scopeRegistry, this.componentManager, this.lcm, this.metaDataStore, this.managementService, this.hostInfo);
        this.registerComponent("RuntimeDomain", Domain.class, this.runtimeDomain, true);
        this.synthesizeContributions();
    }

    @Override
    public void bootSystem() throws Fabric3Exception {
        Composite composite = BootstrapCompositeFactory.createSystemComposite(this.bootContribution, this.hostInfo, this.bootClassLoader, this.implementationIntrospector);
        LogicalProperty logicalProperty = LogicalProperty.Builder.newBuilder("systemConfig", this.domain).xmlValue(this.systemConfig).many(false).build();
        this.domain.setProperties(logicalProperty);
        this.runtimeDomain.include(composite);
    }

    private <S, I extends S> void registerRuntimeComponents(List<ComponentRegistration> registrations) throws Fabric3Exception {
        this.registerComponent("MonitorProxyService", MonitorProxyService.class, this.monitorService, true);
        this.registerComponent("DestinationRouter", DestinationRouter.class, this.router, true);
        Class<HostInfo> type = this.getHostInfoType(this.hostInfo);
        this.registerComponent("HostInfo", type, this.hostInfo, true);
        if (this.mbeanServer != null) {
            this.registerComponent("MBeanServer", MBeanServer.class, this.mbeanServer, false);
        }
        this.registerComponent("ManagementService", ManagementService.class, this.managementService, true);
        this.registerComponent("ComponentManager", ComponentManager.class, this.componentManager, true);
        this.registerComponent("ChannelManager", ChannelManager.class, this.channelManager, true);
        this.registerComponent("RuntimeLogicalComponentManager", LogicalComponentManager.class, this.lcm, true);
        this.registerComponent("CompositeScopeContainer", ScopeContainer.class, this.scopeContainer, true);
        this.registerComponent("ClassLoaderRegistry", ClassLoaderRegistry.class, this.classLoaderRegistry, true);
        this.registerComponent("ScopeRegistry", ScopeRegistry.class, this.scopeRegistry, true);
        this.registerComponent("MetaDataStore", MetaDataStore.class, this.metaDataStore, true);
        this.registerComponent("Monitorable", Monitorable.class, this.runtime, false);
        for (ComponentRegistration registration : registrations) {
            String name = registration.getName();
            Class<?> service = registration.getService();
            Object instance = registration.getInstance();
            boolean introspect = registration.isIntrospect();
            this.registerComponent(name, service, instance, introspect);
        }
    }

    private Class<HostInfo> getHostInfoType(HostInfo info) {
        Class<?>[] interfaces = info.getClass().getInterfaces();
        if (interfaces.length == 1) {
            return HostInfo.class;
        }
        for (Class<HostInfo> clazz : interfaces) {
            if (HostInfo.class.equals(clazz) || !HostInfo.class.isAssignableFrom(clazz)) continue;
            return clazz;
        }
        return HostInfo.class;
    }

    private <S, I extends S> void registerComponent(String name, Class<S> type, I instance, boolean introspect) throws Fabric3Exception {
        this.synthesizer.registerComponent(name, type, instance, introspect);
    }

    private void synthesizeContributions() throws Fabric3Exception {
        this.synthesizeContribution(Names.HOST_CONTRIBUTION, Java6HostExports.getExports(), this.hostCapabilities, this.hostClassLoader, true);
        this.exportedPackages.putAll(BootExports.getExports());
        this.bootContribution = this.synthesizeContribution(Names.BOOT_CONTRIBUTION, this.exportedPackages, Collections.emptyList(), this.bootClassLoader, true);
    }

    private Contribution synthesizeContribution(URI contributionUri, Map<String, String> exportedPackages, List<String> hostCapabilities, ClassLoader loader, boolean extension) throws Fabric3Exception {
        Contribution contribution = new Contribution(contributionUri);
        contribution.install();
        ContributionManifest manifest = contribution.getManifest();
        manifest.setExtension(extension);
        manifest.addExport(new ContributionExport(contributionUri));
        for (Map.Entry<String, String> entry : exportedPackages.entrySet()) {
            Version version = new Version(entry.getValue());
            PackageInfo info = new PackageInfo(entry.getKey(), version);
            JavaExport export = new JavaExport(info);
            manifest.addExport(export);
        }
        for (String capability : hostCapabilities) {
            manifest.addProvidedCapability(new Capability(capability));
        }
        this.metaDataStore.store(contribution);
        this.classLoaderRegistry.register(contributionUri, loader);
        return contribution;
    }
}

