/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.runtime;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.Names;
import org.fabric3.api.host.contribution.ContributionOrder;
import org.fabric3.api.host.contribution.ContributionService;
import org.fabric3.api.host.contribution.ContributionSource;
import org.fabric3.api.host.domain.Domain;
import org.fabric3.api.host.runtime.BootConfiguration;
import org.fabric3.api.host.runtime.Fabric3Runtime;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.host.runtime.RuntimeCoordinator;
import org.fabric3.api.host.runtime.RuntimeState;
import org.fabric3.fabric.runtime.DefaultBootstrapper;
import org.fabric3.spi.runtime.event.EventService;
import org.fabric3.spi.runtime.event.ExtensionsInitialized;
import org.fabric3.spi.runtime.event.JoinDomain;
import org.fabric3.spi.runtime.event.JoinDomainCompleted;
import org.fabric3.spi.runtime.event.RuntimeDestroyed;
import org.fabric3.spi.runtime.event.RuntimeRecover;
import org.fabric3.spi.runtime.event.RuntimeStart;
import org.fabric3.spi.runtime.event.RuntimeStop;
import org.fabric3.spi.runtime.event.TransportStart;
import org.fabric3.spi.runtime.event.TransportStop;

public class DefaultCoordinator
implements RuntimeCoordinator {
    private RuntimeState state = RuntimeState.UNINITIALIZED;
    private BootConfiguration configuration;
    private Fabric3Runtime runtime;

    public DefaultCoordinator(BootConfiguration configuration) {
        this.configuration = configuration;
        this.runtime = configuration.getRuntime();
    }

    @Override
    public RuntimeState getState() {
        return this.state;
    }

    @Override
    public void start() throws Fabric3Exception {
        this.boot();
        this.load();
        this.startRuntime();
        this.startTransports();
    }

    @Override
    public void boot() throws Fabric3Exception {
        this.runtime.boot();
        DefaultBootstrapper bootstrapper = new DefaultBootstrapper(this.configuration);
        bootstrapper.bootRuntimeDomain();
        bootstrapper.bootSystem();
    }

    @Override
    public void load() throws Fabric3Exception {
        this.loadExtensions();
        EventService eventService = this.runtime.getComponent(EventService.class);
        eventService.publish(new ExtensionsInitialized());
        this.recover(eventService);
    }

    @Override
    public void startRuntime() {
        EventService eventService = this.runtime.getComponent(EventService.class);
        eventService.publish(new JoinDomain());
        eventService.publish(new JoinDomainCompleted());
        eventService.publish(new RuntimeStart());
        this.state = RuntimeState.STARTED;
        this.runtime.getComponent(HostInfo.class).notifyCallbacks();
    }

    @Override
    public void startTransports() {
        EventService eventService = this.runtime.getComponent(EventService.class);
        eventService.publish(new TransportStart());
        this.state = RuntimeState.RUNNING;
    }

    @Override
    public void shutdown() throws Fabric3Exception {
        if (this.state == RuntimeState.RUNNING) {
            EventService eventService = this.runtime.getComponent(EventService.class);
            eventService.publish(new TransportStop());
            eventService.publish(new RuntimeStop());
            RuntimeDestroyed destroyed = new RuntimeDestroyed();
            this.runtime.destroy();
            eventService.publish(destroyed);
        }
        this.state = RuntimeState.SHUTDOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadExtensions() throws Fabric3Exception {
        List<ContributionSource> contributions = this.configuration.getExtensionContributions();
        ContributionService contributionService = this.runtime.getComponent(ContributionService.class);
        Domain domain = this.runtime.getComponent(Domain.class, Names.RUNTIME_DOMAIN_SERVICE_URI);
        try {
            ContributionOrder order = contributionService.processManifests(contributions);
            order.getBootstrapContributions().forEach(contributionService::processContents);
            domain.include(order.getBootstrapContributions());
            order.getBaseContributions().forEach(contributionService::processContents);
            domain.include(order.getBaseContributions());
            for (URI uri : order.getIsolatedContributions()) {
                contributionService.processContents(uri);
                domain.include(Collections.singletonList(uri));
            }
        }
        finally {
            this.state = RuntimeState.ERROR;
        }
    }

    private void recover(EventService eventService) throws Fabric3Exception {
        Domain domain = this.runtime.getComponent(Domain.class, Names.APPLICATION_DOMAIN_URI);
        if (domain == null) {
            this.state = RuntimeState.ERROR;
            String name = Names.APPLICATION_DOMAIN_URI.toString();
            throw new Fabric3Exception("Domain not found: " + name);
        }
        eventService.publish(new RuntimeRecover());
    }
}

