/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.runtime.bootstrap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.domain.Domain;
import org.fabric3.api.host.monitor.MonitorProxyService;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.fabric.container.builder.Connector;
import org.fabric3.fabric.container.builder.ConnectorImpl;
import org.fabric3.fabric.container.command.AttachWireCommand;
import org.fabric3.fabric.container.command.AttachWireCommandExecutor;
import org.fabric3.fabric.container.command.BuildComponentCommand;
import org.fabric3.fabric.container.command.BuildComponentCommandExecutor;
import org.fabric3.fabric.container.command.CommandExecutorRegistry;
import org.fabric3.fabric.container.command.CommandExecutorRegistryImpl;
import org.fabric3.fabric.container.command.ConnectionCommand;
import org.fabric3.fabric.container.command.ConnectionCommandExecutor;
import org.fabric3.fabric.container.command.ContextMonitor;
import org.fabric3.fabric.container.command.StartComponentCommand;
import org.fabric3.fabric.container.command.StartComponentCommandExecutor;
import org.fabric3.fabric.container.command.StartContextCommand;
import org.fabric3.fabric.container.command.StartContextCommandExecutor;
import org.fabric3.fabric.contract.DefaultContractMatcher;
import org.fabric3.fabric.contract.JavaContractMatcherExtension;
import org.fabric3.fabric.domain.ContributionHelper;
import org.fabric3.fabric.domain.ContributionHelperImpl;
import org.fabric3.fabric.domain.Deployer;
import org.fabric3.fabric.domain.LocalDeployer;
import org.fabric3.fabric.domain.LogicalComponentManager;
import org.fabric3.fabric.domain.RuntimeDomain;
import org.fabric3.fabric.domain.collector.Collector;
import org.fabric3.fabric.domain.collector.CollectorImpl;
import org.fabric3.fabric.domain.generator.CommandGenerator;
import org.fabric3.fabric.domain.generator.Generator;
import org.fabric3.fabric.domain.generator.GeneratorRegistry;
import org.fabric3.fabric.domain.generator.component.BuildComponentCommandGenerator;
import org.fabric3.fabric.domain.generator.component.StartComponentCommandGenerator;
import org.fabric3.fabric.domain.generator.context.StartContextCommandGeneratorImpl;
import org.fabric3.fabric.domain.generator.context.StopContextCommandGeneratorImpl;
import org.fabric3.fabric.domain.generator.impl.GeneratorImpl;
import org.fabric3.fabric.domain.generator.impl.GeneratorRegistryImpl;
import org.fabric3.fabric.domain.generator.wire.BoundServiceCommandGenerator;
import org.fabric3.fabric.domain.generator.wire.OperationResolverImpl;
import org.fabric3.fabric.domain.generator.wire.PhysicalOperationGeneratorImpl;
import org.fabric3.fabric.domain.generator.wire.ReferenceCommandGenerator;
import org.fabric3.fabric.domain.generator.wire.ResourceReferenceCommandGenerator;
import org.fabric3.fabric.domain.generator.wire.WireGeneratorImpl;
import org.fabric3.fabric.domain.instantiator.LogicalModelInstantiator;
import org.fabric3.fabric.domain.instantiator.LogicalModelInstantiatorImpl;
import org.fabric3.fabric.domain.instantiator.component.AtomicComponentInstantiatorImpl;
import org.fabric3.fabric.domain.instantiator.component.CompositeComponentInstantiatorImpl;
import org.fabric3.fabric.domain.instantiator.wire.AutowireInstantiatorImpl;
import org.fabric3.fabric.domain.instantiator.wire.TypeAutowireResolver;
import org.fabric3.fabric.domain.instantiator.wire.WireInstantiatorImpl;
import org.fabric3.implementation.pojo.builder.ArrayBuilderImpl;
import org.fabric3.implementation.pojo.builder.CollectionBuilderImpl;
import org.fabric3.implementation.pojo.builder.MapBuilderImpl;
import org.fabric3.implementation.pojo.builder.ObjectBuilderImpl;
import org.fabric3.implementation.pojo.builder.PropertySupplierBuilderImpl;
import org.fabric3.implementation.pojo.generator.GenerationHelperImpl;
import org.fabric3.implementation.pojo.manager.ImplementationManagerFactoryBuilderImpl;
import org.fabric3.implementation.pojo.reflection.ReflectionFactoryImpl;
import org.fabric3.implementation.reflection.jdk.JDKConsumerInvokerFactory;
import org.fabric3.implementation.reflection.jdk.JDKInjectorFactory;
import org.fabric3.implementation.reflection.jdk.JDKInstantiatorFactory;
import org.fabric3.implementation.reflection.jdk.JDKLifecycleInvokerFactory;
import org.fabric3.implementation.reflection.jdk.JDKServiceInvokerFactory;
import org.fabric3.implementation.system.generator.SystemComponentGenerator;
import org.fabric3.implementation.system.provision.PhysicalSystemComponent;
import org.fabric3.implementation.system.provision.SystemWireSource;
import org.fabric3.implementation.system.provision.SystemWireTarget;
import org.fabric3.implementation.system.runtime.SystemComponentBuilder;
import org.fabric3.implementation.system.runtime.SystemSourceWireAttacher;
import org.fabric3.implementation.system.runtime.SystemTargetWireAttacher;
import org.fabric3.implementation.system.singleton.SingletonComponentGenerator;
import org.fabric3.implementation.system.singleton.SingletonImplementation;
import org.fabric3.implementation.system.singleton.SingletonSourceWireAttacher;
import org.fabric3.implementation.system.singleton.SingletonTargetWireAttacher;
import org.fabric3.implementation.system.singleton.SingletonWireSource;
import org.fabric3.implementation.system.singleton.SingletonWireTarget;
import org.fabric3.introspection.java.DefaultIntrospectionHelper;
import org.fabric3.monitor.generator.MonitorResourceReferenceGenerator;
import org.fabric3.monitor.model.MonitorResourceReference;
import org.fabric3.monitor.provision.MonitorWireTarget;
import org.fabric3.monitor.runtime.MonitorWireAttacher;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.container.component.ComponentManager;
import org.fabric3.spi.container.component.ScopeRegistry;
import org.fabric3.spi.contract.ContractMatcher;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.management.ManagementService;
import org.fabric3.spi.model.type.system.SystemImplementation;
import org.fabric3.transform.DefaultTransformerRegistry;
import org.fabric3.transform.property.Property2BooleanTransformer;
import org.fabric3.transform.property.Property2ElementTransformer;
import org.fabric3.transform.property.Property2IntegerTransformer;
import org.fabric3.transform.property.Property2QNameTransformer;
import org.fabric3.transform.property.Property2StreamTransformer;
import org.fabric3.transform.property.Property2StringTransformer;
import org.fabric3.transform.string2java.String2ClassTransformer;
import org.fabric3.transform.string2java.String2IntegerTransformer;
import org.fabric3.transform.string2java.String2QNameTransformer;

public class BootstrapAssemblyFactory {
    private BootstrapAssemblyFactory() {
    }

    public static Domain createDomain(MonitorProxyService monitorService, ClassLoaderRegistry classLoaderRegistry, ScopeRegistry scopeRegistry, ComponentManager componentManager, LogicalComponentManager logicalComponentManager, MetaDataStore metaDataStore, ManagementService managementService, HostInfo info) throws Fabric3Exception {
        CommandExecutorRegistry commandRegistry = BootstrapAssemblyFactory.createCommandExecutorRegistry(monitorService, classLoaderRegistry, scopeRegistry, componentManager, managementService, info);
        LocalDeployer deployer = new LocalDeployer(commandRegistry, scopeRegistry);
        DefaultContractMatcher matcher = new DefaultContractMatcher();
        JavaContractMatcherExtension javaMatcher = new JavaContractMatcherExtension();
        matcher.addMatcherExtension(javaMatcher);
        Generator generator = BootstrapAssemblyFactory.createGenerator(matcher, classLoaderRegistry);
        LogicalModelInstantiator logicalModelInstantiator = BootstrapAssemblyFactory.createLogicalModelGenerator(matcher);
        CollectorImpl collector = new CollectorImpl();
        ContributionHelperImpl contributionHelper = new ContributionHelperImpl(metaDataStore, info);
        return new RuntimeDomain(metaDataStore, generator, logicalModelInstantiator, logicalComponentManager, (Deployer)deployer, (Collector)collector, (ContributionHelper)contributionHelper, info);
    }

    private static LogicalModelInstantiator createLogicalModelGenerator(ContractMatcher matcher) {
        TypeAutowireResolver resolver = new TypeAutowireResolver(matcher);
        AutowireInstantiatorImpl autowireInstantiator = new AutowireInstantiatorImpl(resolver);
        AtomicComponentInstantiatorImpl atomicInstantiator = new AtomicComponentInstantiatorImpl();
        WireInstantiatorImpl wireInstantiator = new WireInstantiatorImpl(matcher);
        CompositeComponentInstantiatorImpl compositeInstantiator = new CompositeComponentInstantiatorImpl(atomicInstantiator, wireInstantiator);
        return new LogicalModelInstantiatorImpl(compositeInstantiator, atomicInstantiator, wireInstantiator, autowireInstantiator);
    }

    private static CommandExecutorRegistry createCommandExecutorRegistry(MonitorProxyService monitorService, ClassLoaderRegistry classLoaderRegistry, ScopeRegistry scopeRegistry, ComponentManager componentManager, ManagementService managementService, HostInfo info) {
        DefaultTransformerRegistry transformerRegistry = BootstrapAssemblyFactory.createTransformerRegistry();
        Connector connector = BootstrapAssemblyFactory.createConnector(componentManager, transformerRegistry, monitorService);
        CommandExecutorRegistryImpl commandRegistry = new CommandExecutorRegistryImpl();
        ContextMonitor contextMonitor = monitorService.createMonitor(ContextMonitor.class);
        commandRegistry.register(StartContextCommand.class, new StartContextCommandExecutor(scopeRegistry, contextMonitor));
        BuildComponentCommandExecutor executor = BootstrapAssemblyFactory.createBuildComponentExecutor(componentManager, scopeRegistry, transformerRegistry, classLoaderRegistry, managementService, info);
        commandRegistry.register(BuildComponentCommand.class, executor);
        commandRegistry.register(AttachWireCommand.class, new AttachWireCommandExecutor(connector));
        commandRegistry.register(StartComponentCommand.class, new StartComponentCommandExecutor(componentManager));
        commandRegistry.register(ConnectionCommand.class, new ConnectionCommandExecutor(componentManager, commandRegistry));
        return commandRegistry;
    }

    private static BuildComponentCommandExecutor createBuildComponentExecutor(ComponentManager componentManager, ScopeRegistry scopeRegistry, DefaultTransformerRegistry transformerRegistry, ClassLoaderRegistry classLoaderRegistry, ManagementService managementService, HostInfo info) {
        HashMap builders = new HashMap();
        ArrayBuilderImpl arrayBuilder = new ArrayBuilderImpl(transformerRegistry);
        CollectionBuilderImpl collectionBuilder = new CollectionBuilderImpl(transformerRegistry);
        MapBuilderImpl mapBuilder = new MapBuilderImpl(transformerRegistry);
        ObjectBuilderImpl objectBuilder = new ObjectBuilderImpl(transformerRegistry);
        PropertySupplierBuilderImpl propertyBuilder = new PropertySupplierBuilderImpl(arrayBuilder, collectionBuilder, mapBuilder, objectBuilder);
        DefaultIntrospectionHelper helper = new DefaultIntrospectionHelper();
        JDKInstantiatorFactory instantiatorFactory = new JDKInstantiatorFactory();
        JDKInjectorFactory injectorFactory = new JDKInjectorFactory();
        JDKLifecycleInvokerFactory lifecycleInvokerFactory = new JDKLifecycleInvokerFactory();
        JDKServiceInvokerFactory serviceInvokerFactory = new JDKServiceInvokerFactory();
        JDKConsumerInvokerFactory consumerInvokerFactory = new JDKConsumerInvokerFactory();
        ReflectionFactoryImpl reflectionFactory = new ReflectionFactoryImpl(instantiatorFactory, injectorFactory, lifecycleInvokerFactory, serviceInvokerFactory, consumerInvokerFactory);
        ImplementationManagerFactoryBuilderImpl factoryBuilder = new ImplementationManagerFactoryBuilderImpl(reflectionFactory, classLoaderRegistry);
        SystemComponentBuilder builder = new SystemComponentBuilder(scopeRegistry, factoryBuilder, classLoaderRegistry, propertyBuilder, managementService, helper, info);
        builders.put(PhysicalSystemComponent.class, builder);
        BuildComponentCommandExecutor executor = new BuildComponentCommandExecutor(componentManager);
        executor.setBuilders(builders);
        return executor;
    }

    private static DefaultTransformerRegistry createTransformerRegistry() {
        DefaultTransformerRegistry transformerRegistry = new DefaultTransformerRegistry();
        ArrayList transformers = new ArrayList();
        transformers.add(new Property2StringTransformer());
        transformers.add(new Property2IntegerTransformer());
        transformers.add(new Property2BooleanTransformer());
        transformers.add(new Property2ElementTransformer());
        transformers.add(new Property2QNameTransformer());
        transformers.add(new Property2StreamTransformer());
        transformers.add(new String2ClassTransformer());
        transformers.add(new String2QNameTransformer());
        transformers.add(new String2IntegerTransformer());
        transformerRegistry.setTransformers(transformers);
        return transformerRegistry;
    }

    private static Connector createConnector(ComponentManager componentManager, DefaultTransformerRegistry transformerRegistry, MonitorProxyService monitorService) {
        HashMap sourceAttachers = new HashMap();
        SystemSourceWireAttacher wireAttacher = new SystemSourceWireAttacher(componentManager, transformerRegistry);
        sourceAttachers.put(SystemWireSource.class, wireAttacher);
        sourceAttachers.put(SingletonWireSource.class, new SingletonSourceWireAttacher(componentManager));
        HashMap targetAttachers = new HashMap();
        targetAttachers.put(SingletonWireTarget.class, new SingletonTargetWireAttacher(componentManager));
        targetAttachers.put(SystemWireTarget.class, new SystemTargetWireAttacher(componentManager));
        targetAttachers.put(MonitorWireTarget.class, new MonitorWireAttacher(monitorService, componentManager));
        return new ConnectorImpl(sourceAttachers, targetAttachers);
    }

    private static Generator createGenerator(ContractMatcher matcher, ClassLoaderRegistry classLoaderRegistry) {
        GeneratorRegistry generatorRegistry = BootstrapAssemblyFactory.createGeneratorRegistry();
        List<CommandGenerator> commandGenerators = BootstrapAssemblyFactory.createCommandGenerators(matcher, generatorRegistry, classLoaderRegistry);
        StopContextCommandGeneratorImpl stopContextGenerator = new StopContextCommandGeneratorImpl();
        StartContextCommandGeneratorImpl startContextGenerator = new StartContextCommandGeneratorImpl();
        return new GeneratorImpl(commandGenerators, startContextGenerator, stopContextGenerator);
    }

    private static GeneratorRegistry createGeneratorRegistry() {
        GeneratorRegistryImpl registry = new GeneratorRegistryImpl();
        GenerationHelperImpl helper = new GenerationHelperImpl();
        SystemComponentGenerator systemComponentGenerator = new SystemComponentGenerator(helper);
        SingletonComponentGenerator singletonComponentGenerator = new SingletonComponentGenerator();
        registry.register(SystemImplementation.class, systemComponentGenerator);
        registry.register(SingletonImplementation.class, singletonComponentGenerator);
        registry.register(MonitorResourceReference.class, new MonitorResourceReferenceGenerator());
        return registry;
    }

    private static List<CommandGenerator> createCommandGenerators(ContractMatcher matcher, GeneratorRegistry generatorRegistry, ClassLoaderRegistry classLoaderRegistry) {
        ArrayList<CommandGenerator> commandGenerators = new ArrayList<CommandGenerator>();
        commandGenerators.add(new BuildComponentCommandGenerator(generatorRegistry, classLoaderRegistry));
        OperationResolverImpl operationResolver = new OperationResolverImpl();
        PhysicalOperationGeneratorImpl operationGenerator = new PhysicalOperationGeneratorImpl(operationResolver, generatorRegistry);
        WireGeneratorImpl wireGenerator = new WireGeneratorImpl(generatorRegistry, matcher, operationGenerator, classLoaderRegistry);
        commandGenerators.add(new ReferenceCommandGenerator(wireGenerator));
        commandGenerators.add(new BoundServiceCommandGenerator(wireGenerator));
        commandGenerators.add(new ResourceReferenceCommandGenerator(wireGenerator));
        StartComponentCommandGenerator startGenerator = new StartComponentCommandGenerator();
        commandGenerators.add(startGenerator);
        return commandGenerators;
    }
}

