/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.runtime.bootstrap;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import org.fabric3.api.annotation.Consumer;
import org.fabric3.api.annotation.Producer;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.api.annotation.management.ManagementOperation;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.implementation.system.introspection.SystemConstructorHeuristic;
import org.fabric3.implementation.system.introspection.SystemHeuristic;
import org.fabric3.implementation.system.introspection.SystemImplementationIntrospectorImpl;
import org.fabric3.implementation.system.introspection.SystemServiceHeuristic;
import org.fabric3.implementation.system.introspection.SystemUnannotatedHeuristic;
import org.fabric3.introspection.java.DefaultClassVisitor;
import org.fabric3.introspection.java.DefaultIntrospectionHelper;
import org.fabric3.introspection.java.ReferenceProcessorImpl;
import org.fabric3.introspection.java.annotation.ConsumerProcessor;
import org.fabric3.introspection.java.annotation.ManagementOperationProcessor;
import org.fabric3.introspection.java.annotation.ManagementProcessor;
import org.fabric3.introspection.java.annotation.OASISDestroyProcessor;
import org.fabric3.introspection.java.annotation.OASISEagerInitProcessor;
import org.fabric3.introspection.java.annotation.OASISInitProcessor;
import org.fabric3.introspection.java.annotation.OASISPropertyProcessor;
import org.fabric3.introspection.java.annotation.OASISReferenceProcessor;
import org.fabric3.introspection.java.annotation.OASISServiceProcessor;
import org.fabric3.introspection.java.annotation.ProducerProcessor;
import org.fabric3.introspection.java.contract.JavaContractProcessorImpl;
import org.fabric3.monitor.introspection.MonitorProcessor;
import org.fabric3.spi.introspection.java.ImplementationIntrospector;
import org.fabric3.spi.introspection.java.annotation.AnnotationProcessor;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Service;

public class BootstrapIntrospectionFactory {
    private BootstrapIntrospectionFactory() {
    }

    public static ImplementationIntrospector createSystemImplementationProcessor() {
        DefaultIntrospectionHelper helper = new DefaultIntrospectionHelper();
        JavaContractProcessorImpl contractProcessor = new JavaContractProcessorImpl(helper);
        HashMap<Class<? extends Annotation>, AnnotationProcessor<? extends Annotation>> processors = new HashMap<Class<? extends Annotation>, AnnotationProcessor<? extends Annotation>>();
        ReferenceProcessorImpl referenceProcessor = new ReferenceProcessorImpl(contractProcessor, helper);
        processors.put(Property.class, new OASISPropertyProcessor(helper));
        processors.put(Reference.class, new OASISReferenceProcessor(referenceProcessor));
        processors.put(Service.class, new OASISServiceProcessor(contractProcessor));
        processors.put(EagerInit.class, new OASISEagerInitProcessor());
        processors.put(Init.class, new OASISInitProcessor());
        processors.put(Destroy.class, new OASISDestroyProcessor());
        processors.put(Monitor.class, new MonitorProcessor(helper, contractProcessor));
        processors.put(Producer.class, new ProducerProcessor(contractProcessor, helper));
        processors.put(Consumer.class, new ConsumerProcessor(helper));
        processors.put(Management.class, new ManagementProcessor());
        processors.put(ManagementOperation.class, new ManagementOperationProcessor());
        DefaultClassVisitor classVisitor = new DefaultClassVisitor(processors);
        SystemServiceHeuristic serviceHeuristic = new SystemServiceHeuristic(contractProcessor, helper);
        SystemConstructorHeuristic constructorHeuristic = new SystemConstructorHeuristic();
        SystemUnannotatedHeuristic unannotatedHeuristic = new SystemUnannotatedHeuristic(helper, contractProcessor);
        SystemHeuristic systemHeuristic = new SystemHeuristic(serviceHeuristic, constructorHeuristic, unannotatedHeuristic);
        return new SystemImplementationIntrospectorImpl(classVisitor, systemHeuristic, helper);
    }
}

