/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.runtime.bootstrap;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.contribution.ContributionSource;
import org.fabric3.api.host.contribution.FileContributionSource;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.fabric.runtime.bootstrap.SyntheticContributionSource;

public class ExtensionsScanner {
    public List<ContributionSource> scan(HostInfo info) throws Fabric3Exception {
        return this.scan(info.getExtensionsRepositoryDirectory(), true);
    }

    private List<ContributionSource> scan(File directory, boolean extension) throws Fabric3Exception {
        ArrayList<ContributionSource> sources = new ArrayList<ContributionSource>();
        if (directory == null) {
            return sources;
        }
        File[] files = directory.listFiles(pathname -> !pathname.getName().startsWith("."));
        if (files != null) {
            for (File file : files) {
                try {
                    ContributionSource source;
                    URI uri;
                    URL location = file.toURI().toURL();
                    if (file.isDirectory()) {
                        uri = URI.create("f3-" + file.getName());
                        source = new SyntheticContributionSource(uri, location, extension);
                    } else {
                        uri = URI.create(file.getName());
                        source = new FileContributionSource(uri, location, -1L, extension);
                    }
                    sources.add(source);
                }
                catch (MalformedURLException e) {
                    throw new Fabric3Exception("Error loading extension:" + file.getName(), e);
                }
            }
        }
        return sources;
    }
}

