/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.runtime.event;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.fabric3.spi.runtime.event.EventService;
import org.fabric3.spi.runtime.event.Fabric3Event;
import org.fabric3.spi.runtime.event.Fabric3EventListener;
import org.oasisopen.sca.annotation.EagerInit;

@EagerInit
public class EventServiceImpl
implements EventService {
    private Map<Class<Fabric3Event>, List<Fabric3EventListener<Fabric3Event>>> cache = new ConcurrentHashMap<Class<Fabric3Event>, List<Fabric3EventListener<Fabric3Event>>>();

    @Override
    public void publish(Fabric3Event event) {
        List<Fabric3EventListener<Fabric3Event>> listeners = this.cache.get(event.getClass());
        if (listeners == null) {
            return;
        }
        for (Fabric3EventListener<Fabric3Event> listener : listeners) {
            listener.onEvent(event);
        }
    }

    @Override
    public <T extends Fabric3Event> void subscribe(Class<T> type, Fabric3EventListener<T> listener) {
        List<Fabric3EventListener<Fabric3Event>> listeners = this.cache.get(type);
        if (listeners == null) {
            listeners = new ArrayList<Fabric3EventListener<Fabric3Event>>();
            this.cache.put(type, listeners);
        }
        listeners.add(listener);
    }

    @Override
    public <T extends Fabric3Event> void unsubscribe(Class<T> type, Fabric3EventListener<T> listener) {
        List<Fabric3EventListener<Fabric3Event>> listeners = this.cache.get(type);
        if (listeners == null) {
            return;
        }
        listeners.remove(listener);
    }
}

