/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.synthesizer;

import java.util.List;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.spi.introspection.xml.XmlValidationFailure;

public class InvalidServiceContractException
extends Fabric3Exception {
    private static final long serialVersionUID = 4367622270403828483L;
    private List<ValidationFailure> errors;

    public InvalidServiceContractException(List<ValidationFailure> errors) {
        super("System service contract has errors");
        this.errors = errors;
    }

    @Override
    public String getMessage() {
        if (this.errors == null) {
            return super.getMessage();
        }
        StringBuilder b = new StringBuilder();
        if (this.errors.size() == 1) {
            b.append("1 error was detected: \n");
        } else {
            b.append(this.errors.size()).append(" errors were detected: \n");
        }
        for (ValidationFailure failure : this.errors) {
            if (failure instanceof XmlValidationFailure) {
                b.append("ERROR: ").append(failure.getMessage()).append("\n");
            } else {
                b.append("ERROR: ").append(failure);
            }
            b.append("\n");
        }
        return b.toString();
    }
}

