/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.xml;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.fabric.xml.DocumentLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentLoaderImpl
implements DocumentLoader {
    private static final DocumentBuilderFactory DOCUMENT_FACTORY = DocumentBuilderFactory.newInstance();

    @Override
    public Document load(InputSource source, boolean stripWhitespace) throws Fabric3Exception {
        Document document;
        DocumentBuilder builder = this.getBuilder();
        try {
            document = builder.parse(source);
        }
        catch (IOException | SAXException e) {
            throw new Fabric3Exception(e);
        }
        if (stripWhitespace) {
            this.stripWhitespace(document.getDocumentElement());
        }
        return document;
    }

    @Override
    public void addNamespace(Document document, Node node, String namespace) {
        if (node.getNodeType() != 1) {
            return;
        }
        if (node.getNamespaceURI() == null || "".equals(node.getNamespaceURI())) {
            document.renameNode(node, namespace, node.getNodeName());
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            this.addNamespace(document, children.item(i), "urn:fabric3.org");
        }
    }

    public void stripWhitespace(Element element) {
        NodeList children = element.getChildNodes();
        for (int i = children.getLength() - 1; i >= 0; --i) {
            Node child = children.item(i);
            if (child instanceof Text && ((Text)child).getData().trim().length() == 0) {
                element.removeChild(child);
                continue;
            }
            if (!(child instanceof Element)) continue;
            this.stripWhitespace((Element)child);
        }
    }

    private DocumentBuilder getBuilder() {
        try {
            return DOCUMENT_FACTORY.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        DOCUMENT_FACTORY.setNamespaceAware(true);
    }
}

