/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.builder;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.List;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.spi.model.physical.PhysicalOperation;
import org.fabric3.spi.model.physical.PhysicalWireSource;
import org.fabric3.spi.model.physical.PhysicalWireTarget;

public final class MethodUtils {
    public static Method findMethod(PhysicalWireSource source, PhysicalWireTarget target, PhysicalOperation operation, Class<?> implementationClass, ClassLoader loader) throws Fabric3Exception {
        List<Class<?>> params = operation.getTargetParameterTypes();
        Class[] paramTypes = new Class[params.size()];
        assert (loader != null);
        for (int i = 0; i < params.size(); ++i) {
            paramTypes[i] = params.get(i);
        }
        Method method = null;
        if (operation.isRemotable()) {
            Method[] methods = implementationClass.getMethods();
            String name = operation.getName();
            for (Method entry : methods) {
                if (!name.equals(entry.getName())) continue;
                method = entry;
                break;
            }
            if (method == null) {
                URI sourceUri = source.getUri();
                URI targetUri = target.getUri();
                throw new Fabric3Exception("No matching method found when wiring " + sourceUri + " to " + targetUri);
            }
        } else {
            try {
                method = implementationClass.getMethod(operation.getName(), paramTypes);
            }
            catch (NoSuchMethodException e) {
                URI sourceUri = source.getUri();
                URI targetUri = target.getUri();
                throw new Fabric3Exception("No matching method found when wiring " + sourceUri + " to " + targetUri, e);
            }
        }
        return method;
    }
}

