/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.builder;

import java.lang.reflect.Type;
import java.net.URI;
import java.util.List;
import java.util.function.Supplier;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.model.type.component.Scope;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.api.model.type.java.Injectable;
import org.fabric3.api.model.type.java.InjectableType;
import org.fabric3.api.model.type.java.ManagementInfo;
import org.fabric3.implementation.pojo.builder.JsonObjectBuilder;
import org.fabric3.implementation.pojo.builder.PropertySupplierBuilder;
import org.fabric3.implementation.pojo.component.PojoComponent;
import org.fabric3.implementation.pojo.component.PojoComponentContext;
import org.fabric3.implementation.pojo.component.PojoRequestContext;
import org.fabric3.implementation.pojo.manager.ImplementationManagerFactory;
import org.fabric3.implementation.pojo.provision.PhysicalPojoComponent;
import org.fabric3.implementation.pojo.supplier.UpdatableSupplier;
import org.fabric3.spi.container.builder.ComponentBuilder;
import org.fabric3.spi.container.component.AtomicComponent;
import org.fabric3.spi.container.component.Component;
import org.fabric3.spi.container.component.ScopeRegistry;
import org.fabric3.spi.discovery.ConfigurationRegistry;
import org.fabric3.spi.introspection.TypeMapping;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.management.ManagementService;
import org.fabric3.spi.model.physical.ParamTypes;
import org.fabric3.spi.model.physical.PhysicalComponent;
import org.fabric3.spi.model.physical.PhysicalProperty;
import org.fabric3.spi.model.type.java.JavaGenericType;
import org.fabric3.spi.model.type.java.JavaType;
import org.fabric3.spi.model.type.java.JavaTypeInfo;
import org.oasisopen.sca.annotation.Reference;
import org.w3c.dom.Document;

public abstract class PojoComponentBuilder<PCD extends PhysicalPojoComponent, C extends Component>
implements ComponentBuilder<PCD, C> {
    protected IntrospectionHelper helper;
    private HostInfo info;
    private PropertySupplierBuilder propertyBuilder;
    private ManagementService managementService;
    @Reference
    protected ConfigurationRegistry configurationRegistry;
    @Reference
    protected ScopeRegistry scopeRegistry;
    @Reference(required=false)
    protected JsonObjectBuilder jsonObjectBuilder;

    protected PojoComponentBuilder(PropertySupplierBuilder propertyBuilder, ManagementService managementService, IntrospectionHelper helper, HostInfo info) {
        this.propertyBuilder = propertyBuilder;
        this.managementService = managementService;
        this.helper = helper;
        this.info = info;
    }

    protected void createPropertyFactories(PCD definition, PojoComponent component, ImplementationManagerFactory factory) throws Fabric3Exception {
        List<PhysicalProperty> properties = ((PhysicalComponent)definition).getProperties();
        TypeMapping typeMapping = new TypeMapping();
        this.helper.resolveTypeParameters(factory.getImplementationClass(), typeMapping);
        for (PhysicalProperty property : properties) {
            ClassLoader classLoader;
            DataType dataType;
            Type type;
            Object value;
            String name = property.getName();
            Injectable source = new Injectable(InjectableType.PROPERTY, name);
            if (property.getInstanceValue() != null) {
                factory.setSupplier(source, property::getInstanceValue);
                continue;
            }
            String key = property.getKey();
            if (key != null) {
                value = this.configurationRegistry.getValue(key);
                if (property.isRequired() && value == null) {
                    throw new Fabric3Exception("External property " + key + " not found for component " + component.getUri());
                }
                type = factory.getGenericType(source);
                dataType = this.getDataType(type, typeMapping);
                classLoader = factory.getImplementationClass().getClassLoader();
                Supplier<Object> supplier = this.jsonObjectBuilder != null ? this.jsonObjectBuilder.createSupplier(name, (String)value, dataType, classLoader) : () -> PojoComponentBuilder.lambda$createPropertyFactories$0((String)value);
                factory.setSupplier(source, new UpdatableSupplier<Object>(supplier));
                this.configurationRegistry.registerListener(key, newValue -> {
                    component.startUpdate();
                    Supplier<Object> newSup = this.jsonObjectBuilder != null ? this.jsonObjectBuilder.createSupplier(name, (String)newValue, dataType, classLoader) : () -> newValue;
                    component.setSupplier(source, newSup);
                    component.endUpdate();
                    this.scopeRegistry.getScopeContainer(Scope.COMPOSITE).reinject();
                });
                continue;
            }
            value = property.getXmlValue();
            type = factory.getGenericType(source);
            dataType = this.getDataType(type, typeMapping);
            classLoader = factory.getImplementationClass().getClassLoader();
            boolean many = property.isMany();
            factory.setSupplier(source, this.propertyBuilder.createSupplier(name, dataType, (Document)value, many, classLoader));
        }
    }

    protected void export(PhysicalPojoComponent pojoComponent, AtomicComponent component) throws Fabric3Exception {
        if (pojoComponent.isManaged()) {
            ManagementInfo info = pojoComponent.getManagementInfo();
            URI uri = pojoComponent.getComponentUri();
            this.managementService.export(uri, info, component.createSupplier());
        }
    }

    protected void dispose(PhysicalPojoComponent pojoComponent) throws Fabric3Exception {
        if (pojoComponent.isManaged()) {
            ManagementInfo info = pojoComponent.getManagementInfo();
            URI uri = pojoComponent.getComponentUri();
            this.managementService.remove(uri, info);
        }
    }

    protected void buildContexts(PojoComponent component, ImplementationManagerFactory factory) {
        PojoRequestContext requestContext = new PojoRequestContext();
        factory.setSupplier(Injectable.OASIS_REQUEST_CONTEXT, () -> requestContext);
        PojoComponentContext componentContext = new PojoComponentContext(component, requestContext, this.info);
        factory.setSupplier(Injectable.OASIS_COMPONENT_CONTEXT, () -> componentContext);
    }

    private DataType getDataType(Type type, TypeMapping typeMapping) {
        if (type instanceof Class) {
            Class<?> nonGenericType = (Class<?>)type;
            if (nonGenericType.isPrimitive()) {
                nonGenericType = ParamTypes.PRIMITIVE_TO_OBJECT.get(nonGenericType);
            }
            return new JavaType(nonGenericType);
        }
        JavaTypeInfo info = this.helper.createTypeInfo(type, typeMapping);
        return new JavaGenericType(info);
    }

    private static /* synthetic */ Object lambda$createPropertyFactories$0(String value) {
        return value;
    }
}

